/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.def.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.ops4j.net.FreePort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMIRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RMIRegistry.class);
    private final Integer m_defaultPort;
    private static final int UNSELECTED = -1;
    private final String m_host;
    private Integer m_port = -1;
    private Integer m_altMin;
    private Integer m_altTo;
    private static final int TREASURE = 30;

    public RMIRegistry(Integer defaultPort, Integer alternativeRangeFrom, Integer alternativeRangeTo) {
        try {
            this.m_host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Cannot select localhost. That usually not a good sign for networking..");
        }
        this.m_defaultPort = defaultPort;
        this.m_altMin = alternativeRangeFrom;
        this.m_altTo = alternativeRangeTo;
    }

    public synchronized RMIRegistry selectGracefully() {
        int alternativePort = new FreePort(this.m_altMin.intValue(), this.m_altTo.intValue()).getPort();
        this.m_port = this.select(alternativePort);
        if (this.m_port == -1) {
            throw new IllegalStateException("No port found for RMI at all. Even though " + alternativePort + " should have worked. Thats.. not. good. at. all.");
        }
        this.printTakenStatus();
        return this;
    }

    private void printTakenStatus() {
        int in_use = this.m_port - this.m_altMin + 1;
        int max = this.m_altTo - this.m_altMin;
        String info = "Currently " + in_use + " out of " + max + " ports are in use. Port range is from " + this.m_altMin + " up to " + this.m_altTo;
        if (in_use + 30 > max) {
            LOG.warn("--------------");
            LOG.warn("BEWARE !!! " + info);
            LOG.warn("--------------");
        } else {
            LOG.debug(info);
        }
    }

    private Integer select(int port) {
        if (this.reuseRegistry(port)) {
            LOG.debug("Reuse Registry on " + port);
            return port;
        }
        if (this.createNewRegistry(port)) {
            LOG.debug("Created Registry on " + port);
            return port;
        }
        return -1;
    }

    private boolean createNewRegistry(int port) {
        try {
            Registry registry = LocateRegistry.createRegistry(port);
            return this.verifyRegistry(registry);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean reuseRegistry(int port) {
        Registry reg = null;
        try {
            reg = LocateRegistry.getRegistry(port);
            return this.verifyRegistry(reg);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean verifyRegistry(Registry reg) {
        if (reg != null) {
            try {
                String[] objectsRemote;
                for (String r : objectsRemote = reg.list()) {
                    LOG.info("-- Remotely available already: " + r);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }
}

