/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.remote;

import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.container.remote.options.RBCLookupTimeoutOption;
import org.ops4j.pax.exam.container.remote.options.RBCPortOption;

public class Parser {
    private String m_host;
    private Integer m_port;
    private long m_timeout;

    public Parser(Option[] options) {
        this.extractArguments((RBCPortOption[])OptionUtils.filter(RBCPortOption.class, (Option[])options));
        this.extractArguments((RBCLookupTimeoutOption[])OptionUtils.filter(RBCLookupTimeoutOption.class, (Option[])options));
        assert (this.m_port != null) : "Port should never be null.";
        assert (this.m_host != null) : "Host should never be null.";
    }

    private void extractArguments(RBCLookupTimeoutOption[] options) {
        for (RBCLookupTimeoutOption op : options) {
            this.m_timeout = op.getTimeout();
        }
    }

    private void extractArguments(RBCPortOption[] rbcPortOptions) {
        for (RBCPortOption op : rbcPortOptions) {
            this.m_host = op.getHost();
            this.m_port = op.getPort();
        }
    }

    public String getHost() {
        return this.m_host;
    }

    public Integer getRMIPort() {
        return this.m_port;
    }

    public long getRMILookupTimpout() {
        return this.m_timeout;
    }

    public Integer getPort() {
        return this.m_port;
    }
}

