/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.remote;

import java.util.Objects;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.container.remote.options.RBCLookupTimeoutOption;
import org.ops4j.pax.exam.container.remote.options.RBCPortOption;

public class Parser {
    private String host;
    private Integer port;
    private long timeout;

    public Parser(Option[] options) {
        this.extractArguments((RBCPortOption[])OptionUtils.filter(RBCPortOption.class, (Option[])options));
        this.extractArguments((RBCLookupTimeoutOption[])OptionUtils.filter(RBCLookupTimeoutOption.class, (Option[])options));
        Objects.requireNonNull(this.host, "Host must not be be null.");
        Objects.requireNonNull(this.port, "Port must not be be null.");
    }

    private void extractArguments(RBCLookupTimeoutOption[] options) {
        for (RBCLookupTimeoutOption op : options) {
            this.timeout = op.getTimeout();
        }
    }

    private void extractArguments(RBCPortOption[] rbcPortOptions) {
        for (RBCPortOption op : rbcPortOptions) {
            this.host = op.getHost();
            this.port = op.getPort();
        }
    }

    public String getHost() {
        return this.host;
    }

    public Integer getRMIPort() {
        return this.port;
    }

    public long getRMILookupTimeout() {
        return this.timeout;
    }

    public Integer getPort() {
        return this.port;
    }
}

