/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.reactors;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestProbeProvider;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.intern.DefaultTestAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EagerSingleStagedReactor
implements StagedExamReactor {
    private static Logger LOG = LoggerFactory.getLogger(EagerSingleStagedReactor.class);
    private final List<TestContainer> m_targetContainer;
    private final LinkedHashMap<TestAddress, TestContainer> m_map = new LinkedHashMap();

    public EagerSingleStagedReactor(List<TestContainer> containers, List<TestProbeProvider> mProbes) {
        this.m_targetContainer = containers;
        for (TestContainer container : containers) {
            container.start();
            for (TestProbeProvider builder : mProbes) {
                LOG.debug("installing probe " + builder);
                try {
                    container.install(builder.getStream());
                }
                catch (IOException e) {
                    throw new TestContainerException("Unable to build the probe.", (Throwable)e);
                }
                for (TestAddress a : builder.getTests()) {
                    this.m_map.put(new DefaultTestAddress(a, container.toString(), new Object[0]), container);
                }
            }
        }
    }

    @Override
    public void invoke(TestAddress address) throws Exception {
        assert (address != null) : "TestAddress must not be null.";
        TestContainer testContainer = this.m_map.get(address);
        if (testContainer == null) {
            throw new IllegalArgumentException("TestAddress " + address + " not from this reactor? Got it from getTargets() really?");
        }
        testContainer.call(address);
    }

    @Override
    public Set<TestAddress> getTargets() {
        return this.m_map.keySet();
    }

    @Override
    public void tearDown() {
        for (TestContainer container : this.m_targetContainer) {
            container.stop();
        }
    }
}

