/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.intern;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestProbeProvider;
import org.ops4j.store.Handle;
import org.ops4j.store.Store;

public class DefaultTestProbeProvider
implements TestProbeProvider {
    private Set<TestAddress> tests;
    private Handle probe;
    private Store<InputStream> store;
    private String formattedInfo = "";

    public DefaultTestProbeProvider(Set<TestAddress> tests, Store<InputStream> store, Handle probe) {
        this.tests = tests;
        this.store = store;
        this.probe = probe;
        this.formattedInfo = this.constuctInfo();
    }

    public Set<TestAddress> getTests() {
        return this.tests;
    }

    public InputStream getStream() throws IOException {
        return (InputStream)this.store.load(this.probe);
    }

    public String toString() {
        return this.formattedInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String constuctInfo() {
        ZipInputStream in = null;
        String info = "";
        try {
            info = info + "[Probe ID: " + this.probe.getIdentification() + "]\n";
            info = info + "[Probe Location: " + this.store.getLocation(this.probe).toASCIIString() + "]\n";
            in = new JarInputStream((InputStream)this.store.load(this.probe));
            Manifest man = ((JarInputStream)in).getManifest();
            Attributes mainAttributes = man.getMainAttributes();
            info = info + "[Tests: \n";
            for (TestAddress t : this.tests) {
                info = info + "    SIG=" + t + "\n";
            }
            info = info + "]\n";
            info = info + "[Headers: \n";
            for (Object key : mainAttributes.keySet()) {
                info = info + "    " + key + "=" + mainAttributes.get(key) + "\n";
            }
            info = info + "]\n";
            info = "\n--\n" + info + "--\n";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return info;
    }
}

