/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ops4j.pax.jdbc.config.ConfigLoader;
import org.ops4j.pax.jdbc.config.impl.ServiceTrackerHelper;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalConfigLoader.class);
    private static final Pattern CONFIG_LOADER_PATTERN = Pattern.compile("^([^(]+)\\((.+)\\)$");
    private final ServiceTracker<?, ?> tracker;
    private final Map<String, ConfigLoader> configLoaders = new ConcurrentHashMap<String, ConfigLoader>();

    public ExternalConfigLoader(BundleContext context) {
        this.tracker = ServiceTrackerHelper.helper(context).track(ConfigLoader.class, "(objectClass=" + ConfigLoader.class.getName() + ")", configLoader -> this.configLoaders.put(configLoader.getName(), (ConfigLoader)configLoader), configLoader -> this.configLoaders.remove(configLoader.getName()));
    }

    public void destroy() {
        this.tracker.close();
    }

    public Dictionary<String, Object> resolve(Dictionary config) {
        Hashtable<String, Object> loadedConfig = new Hashtable<String, Object>();
        Enumeration e = config.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = String.valueOf(config.get(key));
            if (config.get(key) instanceof String && this.isExternal(value)) {
                ConfigLoader configLoader;
                Matcher matcher = CONFIG_LOADER_PATTERN.matcher(value);
                matcher.matches();
                String loadedValue = null;
                loadedValue = "ENC".equals(matcher.group(1)) ? value : ((configLoader = this.configLoaders.get(matcher.group(1))) != null ? configLoader.resolve(matcher.group(2)) : value);
                if (loadedValue == null) continue;
                ((Dictionary)loadedConfig).put(key, loadedValue);
                continue;
            }
            ((Dictionary)loadedConfig).put(key, config.get(key));
        }
        return loadedConfig;
    }

    private boolean isExternal(String value) {
        return CONFIG_LOADER_PATTERN.matcher(value).matches();
    }
}

