/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.spi.ThrowableRenderer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class OsgiThrowableRenderer
implements ThrowableRenderer {
    private SecurityManagerEx sm = new SecurityManagerEx();

    public String[] doRender(Throwable throwable) {
        try {
            ArrayList lines = new ArrayList();
            this.doRender(throwable, null, lines);
            return lines.toArray(new String[lines.size()]);
        }
        catch (Exception exception) {
            return DefaultThrowableRenderer.render(throwable);
        }
    }

    protected void doRender(Throwable throwable, StackTraceElement[] causedTrace, List lines) {
        int i;
        Class[] classCtx;
        StackTraceElement[] elements = throwable.getStackTrace();
        HashMap<String, String> classMap = new HashMap<String, String>();
        try {
            classCtx = (Class[])Exception.class.getMethod("getClassContext", null).invoke((Object)throwable, null);
        }
        catch (Exception e) {
            classCtx = this.sm.getClassContext();
        }
        Class<?> lastClass = null;
        for (i = 0; i < elements.length && i < classCtx.length; ++i) {
            String classDetails;
            Class<?> clazz = classCtx[classCtx.length - 1 - i];
            if (elements[elements.length - 1 - i].getClassName().equals(clazz.getName())) {
                classDetails = this.getClassDetail(clazz);
                classMap.put(clazz.getName(), classDetails);
                lastClass = clazz;
                continue;
            }
            if (lastClass == null) break;
            try {
                clazz = lastClass.getClassLoader().loadClass(elements[elements.length - 1 - i].getClassName());
                classDetails = this.getClassDetail(clazz);
                classMap.put(clazz.getName(), classDetails);
                lastClass = clazz;
                continue;
            }
            catch (ClassNotFoundException e) {
                break;
            }
        }
        if (causedTrace != null) {
            int m = elements.length - 1;
            for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && elements[m].equals(causedTrace[n]); --m, --n) {
            }
            int framesInCommon = elements.length - 1 - m;
            lines.add("Caused by: " + throwable.toString());
            for (int i2 = 0; i2 <= m; ++i2) {
                lines.add(this.formatElement(elements[i2], classMap));
            }
            if (framesInCommon != 0) {
                lines.add("\t... " + framesInCommon + " more");
            }
        } else {
            lines.add(throwable.toString());
            for (i = 0; i < elements.length; ++i) {
                lines.add(this.formatElement(elements[i], classMap));
            }
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            this.doRender(cause, elements, lines);
        }
    }

    private String formatElement(StackTraceElement element, Map classMap) {
        StringBuffer buf = new StringBuffer("\tat ");
        buf.append(element);
        try {
            String className = element.getClassName();
            Object classDetails = classMap.get(className);
            if (classDetails == null) {
                Class cls = this.findClass(className);
                classDetails = this.getClassDetail(cls);
                classMap.put(className, classDetails);
            }
            if (classDetails != null) {
                buf.append(classDetails);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return buf.toString();
    }

    private String getClassDetail(Class cls) {
        try {
            Method getBundleMethod = FrameworkUtil.class.getMethod("getBundle", Class.class);
            Bundle bundle = (Bundle)getBundleMethod.invoke(null, cls);
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            buf.append(bundle.getBundleId());
            buf.append(":");
            buf.append(bundle.getSymbolicName());
            buf.append(":");
            buf.append(bundle.getHeaders().get("Bundle-Version"));
            buf.append(']');
            return buf.toString();
        }
        catch (Exception e) {
            String implVersion;
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            try {
                URL locationURL;
                CodeSource source = cls.getProtectionDomain().getCodeSource();
                if (source != null && (locationURL = source.getLocation()) != null) {
                    if ("file".equals(locationURL.getProtocol())) {
                        String path = locationURL.getPath();
                        if (path != null) {
                            int lastSlash = path.lastIndexOf(47);
                            int lastBack = path.lastIndexOf(File.separatorChar);
                            if (lastBack > lastSlash) {
                                lastSlash = lastBack;
                            }
                            if (lastSlash <= 0 || lastSlash == path.length() - 1) {
                                buf.append(locationURL);
                            } else {
                                buf.append(path.substring(lastSlash + 1));
                            }
                        }
                    } else {
                        buf.append(locationURL);
                    }
                }
            }
            catch (SecurityException ex) {
                // empty catch block
            }
            buf.append(':');
            Package pkg = cls.getPackage();
            if (pkg != null && (implVersion = pkg.getImplementationVersion()) != null) {
                buf.append(implVersion);
            }
            buf.append(']');
            return buf.toString();
        }
    }

    private Class findClass(String className) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                return this.getClass().getClassLoader().loadClass(className);
            }
        }
    }

    static class SecurityManagerEx
    extends SecurityManager {
        SecurityManagerEx() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

