/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.tinybundles.core.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.io.StreamUtils;
import org.ops4j.pax.swissbox.tinybundles.core.BuildableBundle;
import org.ops4j.pax.swissbox.tinybundles.core.intern.Info;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawBuilder
implements BuildableBundle {
    private static Log LOG = LogFactory.getLog(RawBuilder.class);
    private static final String ENTRY_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String BUILT_BY = "Built-By";
    private static final String TOOL = "Tool";
    private static final String CREATED_BY = "Created-By";

    @Override
    public InputStream build(Map<String, URL> resources, Map<String, String> headers) {
        return this.make(resources, headers);
    }

    public InputStream make(final Map<String, URL> resources, final Map<String, String> headers) {
        LOG.debug((Object)"setResources()");
        PipedInputStream pin = new PipedInputStream();
        try {
            final PipedOutputStream pout = new PipedOutputStream(pin);
            final JarOutputStream jarOut = new JarOutputStream(pout);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        JarEntry entry = new JarEntry(RawBuilder.ENTRY_MANIFEST);
                        jarOut.putNextEntry(entry);
                        RawBuilder.this.getManifest(headers.entrySet()).write(jarOut);
                        jarOut.closeEntry();
                        for (Map.Entry entryset : resources.entrySet()) {
                            entry = new JarEntry((String)entryset.getKey());
                            LOG.debug((Object)("Copying resource " + entry.getName()));
                            jarOut.putNextEntry(entry);
                            InputStream inp = ((URL)entryset.getValue()).openStream();
                            StreamUtils.copyStream((InputStream)inp, (OutputStream)jarOut, (boolean)false);
                            jarOut.closeEntry();
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Problem!", (Throwable)e);
                    }
                    finally {
                        try {
                            if (jarOut != null) {
                                jarOut.close();
                            }
                            pout.close();
                        }
                        catch (Exception exception) {}
                        LOG.info((Object)"Copy thread finished.");
                    }
                }
            }.start();
        }
        catch (IOException e) {
            LOG.error((Object)"Problem..", (Throwable)e);
        }
        return pin;
    }

    private Manifest getManifest(Set<Map.Entry<String, String>> headers) {
        LOG.debug((Object)"Creating manifest from added headers.");
        Manifest man = new Manifest();
        String cre = "pax-swissbox-tinybundles-" + Info.getPaxSwissboxTinybundlesVersion();
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue(BUILT_BY, System.getProperty("user.name"));
        man.getMainAttributes().putValue(CREATED_BY, cre);
        man.getMainAttributes().putValue(TOOL, cre);
        man.getMainAttributes().putValue("SwissboxTinybundlesVersion", cre);
        for (Map.Entry<String, String> entry : headers) {
            LOG.debug((Object)(entry.getKey() + " = " + entry.getValue()));
            man.getMainAttributes().putValue(entry.getKey(), entry.getValue());
        }
        return man;
    }

    public InputStream make(InputStream inp) {
        return inp;
    }
}

