/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.workflow;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.overlord.sramp.governance.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Multipart {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void post(HttpClient httpclient, URI uri, Map<String, Object> parameters) throws IOException, WorkflowException {
        MultipartEntity multiPartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (String key : parameters.keySet()) {
            ByteArrayBody content = null;
            Object param = parameters.get(key);
            if (param instanceof String) {
                StringBody stringBody = new StringBody((String)param, "text/plain", Charset.forName("UTF-8"));
                content = stringBody;
            } else {
                ByteArrayBody byteBody;
                content = byteBody = new ByteArrayBody(null, key);
            }
            multiPartEntity.addPart(key, (ContentBody)content);
        }
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity((HttpEntity)multiPartEntity);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        InputStream is = response.getEntity().getContent();
        String responseStr = IOUtils.toString((InputStream)is);
        if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
            throw new WorkflowException("Workflow ERROR - HTTP STATUS CODE " + response.getStatusLine().getStatusCode() + ". " + response.getStatusLine().getReasonPhrase() + ". " + responseStr);
        }
        this.logger.debug(responseStr);
        is.close();
    }
}

