/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.ant.user;

import java.io.Console;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class InputPassword
extends Task {
    private String addproperty;
    private String message;
    private String confirmationMessage;
    private boolean password;
    private Integer minimumLength;
    private boolean numbersRequired;
    private boolean nonAlphaNumericsRequired;

    public String getAddproperty() {
        return this.addproperty;
    }

    public void setAddproperty(String addproperty) {
        this.addproperty = addproperty;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getConfirmationMessage() {
        return this.confirmationMessage;
    }

    public void setConfirmationMessage(String confirmationMessage) {
        this.confirmationMessage = confirmationMessage;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public Integer getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(Integer minimumLength) {
        this.minimumLength = minimumLength;
    }

    public boolean isNumbersRequired() {
        return this.numbersRequired;
    }

    public void setNumbersRequired(boolean numbersRequired) {
        this.numbersRequired = numbersRequired;
    }

    public boolean isNonAlphaNumericsRequired() {
        return this.nonAlphaNumericsRequired;
    }

    public void setNonAlphaNumericsRequired(boolean nonAlphaNumericsRequired) {
        this.nonAlphaNumericsRequired = nonAlphaNumericsRequired;
    }

    public void execute() throws BuildException {
        Console console = System.console();
        if (console == null) {
            throw new BuildException("\tConsole is not available");
        }
        if (this.addproperty == null || this.addproperty.equals("")) {
            throw new BuildException("\tThe output property is required for this task.");
        }
        if (this.message == null || this.message.equals("")) {
            throw new BuildException("\tThe message property is required for this task.");
        }
        if (this.confirmationMessage == null || this.confirmationMessage.equals("")) {
            throw new BuildException("\tThe confirmationMessage property is required for this task.");
        }
        String currentPropVal = this.getProject().getProperty(this.addproperty);
        if (currentPropVal == null || currentPropVal.trim().isEmpty()) {
            String value = "";
            String repeatedPassword = "";
            boolean validated = false;
            do {
                validated = true;
                console.printf(this.message, new Object[0]);
                if (this.isPassword()) {
                    char[] readed = null;
                    readed = console.readPassword();
                    value = new String(readed);
                } else {
                    value = console.readLine();
                }
                validated = this.validate(value);
                if (!validated) continue;
                console.printf(this.confirmationMessage, new Object[0]);
                repeatedPassword = this.isPassword() ? new String(console.readPassword()) : console.readLine();
                if (value.equals(repeatedPassword)) continue;
                this.log("");
                this.log(" * Error *\nThe values you entered do not match. Please try again.");
                validated = false;
            } while (!validated);
            if (this.addproperty != null && !this.addproperty.equals("")) {
                this.getProject().setProperty(this.addproperty, value);
            }
        }
    }

    private boolean validate(String value) {
        if (this.minimumLength != null && this.minimumLength > 0 && value.length() < this.minimumLength) {
            this.log(" * Error *\nThe length of the password should be at least " + this.minimumLength + " characters.");
            return false;
        }
        if (this.numbersRequired && !value.matches(".*\\d+.*")) {
            this.log("");
            this.log(" * Error *\nThe password should include at least one number.");
            return false;
        }
        if (this.nonAlphaNumericsRequired && !value.matches("^.*[^a-zA-Z0-9 ].*$")) {
            this.log(" * Error *\nThe password should contain at least one non-alphanumeric (symbol) character.");
            return false;
        }
        return true;
    }
}

