/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.jboss7.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.security.vault.VaultSession;
import org.overlord.commons.auth.jboss7.Messages;

public class AuthTool {
    public static void main(String[] args) {
        try {
            Options options = Options.parse(args);
            if (options.execType == ExecType.storepassword) {
                AuthTool.storePassword(options);
            }
            if (options.execType == ExecType.adduser) {
                AuthTool.addUser(options);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected static void storePassword(Options options) throws Exception {
        System.out.println(Messages.getString("AuthTool.StoringPassword"));
        String vaultdir = options.cmdLineOptions.get("vaultdir");
        String keystore = options.cmdLineOptions.get("keystore");
        String storepass = options.cmdLineOptions.get("storepass");
        String alias = options.cmdLineOptions.get("alias");
        String salt = options.cmdLineOptions.get("salt");
        String count = options.cmdLineOptions.get("count");
        String block = options.cmdLineOptions.get("block");
        String name = options.cmdLineOptions.get("name");
        String password = options.cmdLineOptions.get("password");
        String propertyfile = options.cmdLineOptions.get("propertyfile");
        String property = options.cmdLineOptions.get("property");
        if (vaultdir == null || keystore == null || storepass == null || salt == null || alias == null || count == null || name == null || password == null || block == null) {
            throw new Exception(Messages.getString("AuthTool.MissingRequiredArgument"));
        }
        VaultSession session = new VaultSession(keystore, storepass, vaultdir, salt, Integer.parseInt(count));
        session.startVaultSession(alias);
        String vaultHash = session.addSecuredAttribute(block, name, password.toCharArray());
        System.out.println(Messages.getString("AuthTool.PasswordStored"));
        System.out.println(vaultHash);
        if (property != null && propertyfile != null) {
            AuthTool.outputResult(vaultHash, propertyfile, property);
        }
    }

    protected static void addUser(Options options) throws Exception {
        System.out.println(Messages.getString("AuthTool.AddingUser"));
        String configdir = options.cmdLineOptions.get("configdir");
        String vaultdir = options.cmdLineOptions.get("vaultdir");
        String keystore = options.cmdLineOptions.get("keystore");
        String storepass = options.cmdLineOptions.get("storepass");
        String alias = options.cmdLineOptions.get("alias");
        String salt = options.cmdLineOptions.get("salt");
        String count = options.cmdLineOptions.get("count");
        String user = options.cmdLineOptions.get("user");
        String password = options.cmdLineOptions.get("password");
        String roles = options.cmdLineOptions.get("roles");
        String propertyfile = options.cmdLineOptions.get("propertyfile");
        String property = options.cmdLineOptions.get("property");
        String block = "overlord";
        String name = user + ".password";
        if (vaultdir == null || keystore == null || storepass == null || salt == null || alias == null || count == null || user == null || password == null) {
            throw new Exception(Messages.getString("AuthTool.MissingRequiredArgument"));
        }
        VaultSession session = new VaultSession(keystore, storepass, vaultdir, salt, Integer.parseInt(count));
        session.startVaultSession(alias);
        String vaultHash = session.addSecuredAttribute(block, name, password.toCharArray());
        System.out.println(Messages.getString("AuthTool.NewUserPasswordStored"));
        System.out.println(vaultHash);
        AuthTool.createUser(user, roles, vaultHash, configdir);
        if (property != null && propertyfile != null) {
            AuthTool.outputResult(vaultHash, propertyfile, property);
        }
        System.out.println(Messages.getString("AuthTool.UserCreated"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createUser(String user, String roles, String vaultHash, String configdir) throws Exception {
        File usersFile = new File(configdir, "overlord-idp-users.properties");
        File rolesFile = new File(configdir, "overlord-idp-roles.properties");
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(usersFile, true);
            writer.write(user);
            writer.write("=");
            writer.write(vaultHash);
            writer.write("\n");
            writer.flush();
        }
        finally {
            writer.close();
        }
        try {
            writer = new FileWriter(rolesFile, true);
            writer.write(user);
            writer.write("=");
            if (roles == null) {
                writer.write("overlorduser,admin.sramp");
            } else {
                writer.write("overlorduser,admin.sramp," + roles);
            }
            writer.write("\n");
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outputResult(String vaultHash, String propertyfile, String property) throws Exception {
        Properties props = new Properties();
        props.put(property, vaultHash);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(propertyfile);
            props.store(fos, property);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    private static enum ExecType {
        adduser,
        storepassword;

    }

    private static final class Options {
        public ExecType execType;
        public Map<String, String> cmdLineOptions = new HashMap<String, String>();

        private Options() {
        }

        public static final Options parse(String[] args) throws Exception {
            if (args.length == 0) {
                throw new Exception(Messages.getString("AuthTool.MissingToolTypeArgument"));
            }
            Options options = new Options();
            String et = args[0];
            options.execType = ExecType.valueOf(et);
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].startsWith("-")) continue;
                String key = args[i].substring(1);
                String value = null;
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    value = args[i + 1];
                }
                options.cmdLineOptions.put(key, value);
            }
            return options;
        }
    }
}

