/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.tomcat7;

import java.io.File;
import java.security.Principal;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.realm.GenericPrincipal;
import org.overlord.commons.auth.tomcat7.HttpRequestThreadLocalValve;
import org.overlord.commons.auth.util.SAMLAssertionFactory;
import org.overlord.commons.auth.util.SAMLBearerTokenUtil;

public class TomcatSAMLAssertionFactory
implements SAMLAssertionFactory {
    public boolean accept() {
        File f;
        String property = System.getProperty("catalina.home");
        return property != null && (f = new File(property, "bin/catalina.sh")).isFile();
    }

    public String createSAMLAssertion(String issuerName, String forService, int timeValidInMillis) {
        try {
            HttpServletRequest request = HttpRequestThreadLocalValve.TL_request.get();
            Principal principal = request.getUserPrincipal();
            if (principal instanceof GenericPrincipal) {
                GenericPrincipal gp = (GenericPrincipal)principal;
                String[] gpRoles = gp.getRoles();
                HashSet<String> roles = new HashSet<String>(gpRoles.length);
                for (String role : gpRoles) {
                    roles.add(role);
                }
                return SAMLBearerTokenUtil.createSAMLAssertion((Principal)principal, roles, (String)issuerName, (String)forService, (int)timeValidInMillis);
            }
            throw new Exception("Unexpected/unsupported principal type: " + principal.getClass());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

