/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.util;

import java.util.Set;
import org.overlord.commons.auth.util.SAMLAssertionFactory;
import org.overlord.commons.auth.util.StandardSAMLAssertionFactory;
import org.overlord.commons.services.ServiceRegistryUtil;

public class SAMLAssertionUtil {
    private static final SAMLAssertionFactory standardFactory = new StandardSAMLAssertionFactory();
    private static SAMLAssertionFactory cachedFactory;

    public static String createSAMLAssertion(String issuerName, String forService) {
        return SAMLAssertionUtil.createSAMLAssertion(issuerName, forService, 10000);
    }

    public static String createSAMLAssertion(String issuerName, String forService, int timeValidInMillis) {
        SAMLAssertionFactory factory = SAMLAssertionUtil.getSAMLAssertionFactory();
        if (factory == null) {
            throw new RuntimeException("Failed to create SAML Assertion:  Unsupported/undetected platform.");
        }
        return factory.createSAMLAssertion(issuerName, forService, timeValidInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SAMLAssertionFactory getSAMLAssertionFactory() {
        if (standardFactory.accept()) {
            return standardFactory;
        }
        if (cachedFactory != null) {
            return cachedFactory;
        }
        Set factories = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SAMLAssertionUtil.class.getClassLoader());
        try {
            factories = ServiceRegistryUtil.getServices(SAMLAssertionFactory.class);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        for (SAMLAssertionFactory factory : factories) {
            if (!factory.accept()) continue;
            cachedFactory = factory;
            return factory;
        }
        return null;
    }
}

