/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.util;

import java.util.Set;
import org.overlord.commons.auth.filters.HttpRequestThreadLocalFilter;
import org.overlord.commons.auth.util.IRoleGenerator;
import org.overlord.commons.services.ServiceRegistryUtil;

public class RoleUtil {
    private static IRoleGenerator cachedGenerator;

    public static Set<String> generateRoles() {
        IRoleGenerator generator = RoleUtil.getRoleGenerator();
        if (generator == null) {
            throw new RuntimeException("Failed to generate user roles:  Unsupported/undetected platform.");
        }
        return generator.generateRoles(HttpRequestThreadLocalFilter.TL_request.get());
    }

    private static IRoleGenerator getRoleGenerator() {
        if (cachedGenerator != null) {
            return cachedGenerator;
        }
        Set generators = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(RoleUtil.class.getClassLoader());
        try {
            generators = ServiceRegistryUtil.getServices(IRoleGenerator.class);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        for (IRoleGenerator generator : generators) {
            if (!generator.accept()) continue;
            cachedGenerator = generator;
            return cachedGenerator;
        }
        return null;
    }
}

