/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.util;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.overlord.commons.auth.Messages;
import org.overlord.commons.auth.filters.HttpRequestThreadLocalFilter;
import org.overlord.commons.auth.util.SAMLAssertionFactory;
import org.overlord.commons.auth.util.SAMLBearerTokenUtil;

public class StandardSAMLAssertionFactory
implements SAMLAssertionFactory {
    @Override
    public boolean accept() {
        HttpServletRequest request = HttpRequestThreadLocalFilter.TL_request.get();
        if (request == null) {
            return false;
        }
        HttpSession session = request.getSession();
        return session.getAttribute("picketlink.principal") != null && session.getAttribute("picketlink.roles") != null;
    }

    @Override
    public String createSAMLAssertion(String issuerName, String forService, int timeValidInMillis) {
        HttpServletRequest request = HttpRequestThreadLocalFilter.TL_request.get();
        if (request == null) {
            throw new RuntimeException(Messages.format("StandardSAMLAssertionFactory.MissingRequest", new Object[0]));
        }
        HttpSession session = request.getSession();
        Principal principal = (Principal)session.getAttribute("picketlink.principal");
        List roles = (List)session.getAttribute("picketlink.roles");
        return SAMLBearerTokenUtil.createSAMLAssertion(principal, new HashSet<String>(roles), issuerName, forService, timeValidInMillis);
    }
}

