/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.XMLGregorianCalendar;
import org.overlord.commons.auth.Messages;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLBearerTokenUtil {
    public static String createSAMLAssertion(Principal principal, Set<String> roles, String issuerName, String forService) {
        return SAMLBearerTokenUtil.createSAMLAssertion(principal, roles, issuerName, forService, 10000);
    }

    public static String createSAMLAssertion(Principal principal, Set<String> roles, String issuerName, String forService, int timeValidInMillis) {
        try {
            NameIDType issuer = SAMLAssertionFactory.createNameID(null, null, (String)issuerName);
            SubjectType subject = AssertionUtil.createAssertionSubject((String)principal.getName());
            AssertionType assertion = AssertionUtil.createAssertion((String)UUID.randomUUID().toString(), (NameIDType)issuer);
            assertion.setSubject(subject);
            AssertionUtil.createTimedConditions((AssertionType)assertion, (long)timeValidInMillis);
            AudienceRestrictionType restriction = SAMLAssertionFactory.createAudienceRestriction((String[])new String[]{forService});
            assertion.getConditions().addCondition((ConditionAbstractType)restriction);
            SAMLBearerTokenUtil.addRoleStatements(roles, assertion, principal);
            return AssertionUtil.asString((AssertionType)assertion);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addRoleStatements(Set<String> roles, AssertionType assertion, Principal principal) {
        AttributeType attribute = new AttributeType("Role");
        AttributeStatementType.ASTChoiceType attributeAST = new AttributeStatementType.ASTChoiceType(attribute);
        AttributeStatementType roleStatement = new AttributeStatementType();
        roleStatement.addAttribute(attributeAST);
        if (roles != null) {
            for (String role : roles) {
                attribute.addAttributeValue((Object)role);
            }
        }
        assertion.addStatement((StatementAbstractType)roleStatement);
    }

    public static String signSAMLAssertion(String assertion, KeyPair keypair) {
        try {
            Document samlDocument = DocumentUtil.getDocument((String)assertion);
            SAML2Signature sig = new SAML2Signature();
            sig.signSAMLDocument(samlDocument, keypair);
            return DocumentUtil.getDocumentAsString((Document)samlDocument);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSAMLAssertionSignatureValid(Document samlAssertion, KeyPair keyPair) {
        return AssertionUtil.isSignatureValid((Element)samlAssertion.getDocumentElement(), (PublicKey)keyPair.getPublic());
    }

    public static KeyPair getKeyPair(KeyStore keystore, String keyAlias, String keyPassword) throws Exception {
        try {
            Key key = keystore.getKey(keyAlias, keyPassword.toCharArray());
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(keyAlias);
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
            throw new Exception(Messages.format("SAMLBearerTokenUtil.FailedToGetKeyPair.IncorrectKeyType", keyAlias));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(Messages.format("SAMLBearerTokenUtil.FailedToGetKeyPair.Alias", keyAlias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeystore(String keystorePath, String keystorePassword) throws Exception {
        File keystoreFile = new File(keystorePath);
        if (!keystoreFile.isFile()) {
            throw new Exception(Messages.format("SAMLBearerTokenUtil.NoKeystore", keystorePath));
        }
        KeyStore keystore = KeyStore.getInstance("jks");
        FileInputStream is = null;
        try {
            is = new FileInputStream(keystoreFile);
            keystore.load(is, keystorePassword.toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void validateAssertion(AssertionType assertion, HttpServletRequest request, Set<String> allowedIssuers) throws LoginException {
        block6: {
            String issuer = assertion.getIssuer().getValue();
            if (allowedIssuers != null && !allowedIssuers.contains(issuer)) {
                throw new LoginException(Messages.format("SAMLBearerTokenUtil.BadIssuer", issuer, allowedIssuers.toString()));
            }
            String currentAudience = request.getContextPath();
            Set<String> audienceRestrictions = SAMLBearerTokenUtil.getAudienceRestrictions(assertion);
            if (!audienceRestrictions.contains(currentAudience)) {
                throw new LoginException(Messages.format("SAMLBearerTokenUtil.InvalidAudienceRestrictions", currentAudience));
            }
            try {
                ConditionsType conditionsType = assertion.getConditions();
                if (conditionsType != null) {
                    XMLGregorianCalendar notOnOrAfter;
                    XMLGregorianCalendar notBefore;
                    XMLGregorianCalendar now = XMLTimeUtil.getIssueInstant();
                    if (!XMLTimeUtil.isValid((XMLGregorianCalendar)now, (XMLGregorianCalendar)(notBefore = conditionsType.getNotBefore()), (XMLGregorianCalendar)(notOnOrAfter = conditionsType.getNotOnOrAfter()))) {
                        String msg = Messages.format("SAMLBearerTokenUtil.AssertionExpired", now.toXMLFormat(), notBefore.toXMLFormat(), notOnOrAfter);
                        throw new LoginException(msg);
                    }
                    break block6;
                }
                throw new LoginException(Messages.getString("SAMLBearerTokenUtil.InvalidAssertion"));
            }
            catch (Exception e) {
                throw new LoginException(e.getMessage());
            }
        }
    }

    private static Set<String> getAudienceRestrictions(AssertionType assertion) {
        HashSet<String> rval = new HashSet<String>();
        if (assertion == null || assertion.getConditions() == null || assertion.getConditions().getConditions() == null) {
            return rval;
        }
        List conditions = assertion.getConditions().getConditions();
        for (ConditionAbstractType conditionAbstractType : conditions) {
            if (!(conditionAbstractType instanceof AudienceRestrictionType)) continue;
            AudienceRestrictionType art = (AudienceRestrictionType)conditionAbstractType;
            List audiences = art.getAudience();
            for (URI uri : audiences) {
                rval.add(uri.toString());
            }
        }
        return rval;
    }
}

