/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.lang.text.StrLookup;
import org.overlord.commons.config.SystemPropertiesConfiguration;
import org.overlord.commons.config.vault.VaultLookup;

public class ConfigurationFactory {
    private static boolean globalLookupsRegistered = false;

    public static Configuration createConfig(String configFileOverride, String standardConfigFileName, Long refreshDelay, String defaultConfigPath, Class<?> defaultConfigLoader) {
        ConfigurationFactory.registerGlobalLookups();
        try {
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)new SystemPropertiesConfiguration());
            URL url = ConfigurationFactory.findConfig(configFileOverride, standardConfigFileName);
            if (url != null) {
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(url);
                FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
                fileChangedReloadingStrategy.setRefreshDelay(refreshDelay.longValue());
                propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
                config.addConfiguration((Configuration)propertiesConfiguration);
            }
            if (defaultConfigPath != null) {
                config.addConfiguration((Configuration)new PropertiesConfiguration(defaultConfigLoader.getResource(defaultConfigPath)));
            }
            return config;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized void registerGlobalLookups() {
        if (!globalLookupsRegistered) {
            ConfigurationInterpolator.registerGlobalLookup((String)"vault", (StrLookup)new VaultLookup());
            globalLookupsRegistered = true;
        }
    }

    private static URL findConfig(String configFileOverride, String standardConfigFileName) {
        try {
            if (configFileOverride != null) {
                URL fromClasspath = Thread.currentThread().getContextClassLoader().getResource(configFileOverride);
                if (fromClasspath != null) {
                    return fromClasspath;
                }
                File file = new File(configFileOverride);
                if (file.isFile()) {
                    return file.toURI().toURL();
                }
            } else {
                File cfile;
                File dirFile;
                File cfile2;
                File dirFile2;
                File cfile3;
                File dirFile3;
                File cfile4;
                File dirFile4;
                File cfile5;
                File dirFile5;
                String userHomeDir = System.getProperty("user.home");
                if (userHomeDir != null && (dirFile5 = new File(userHomeDir)).isDirectory() && (cfile5 = new File(dirFile5, standardConfigFileName)).isFile()) {
                    return cfile5.toURI().toURL();
                }
                String jbossConfigDir = System.getProperty("jboss.server.config.dir");
                if (jbossConfigDir != null && (dirFile4 = new File(jbossConfigDir)).isDirectory() && (cfile4 = new File(dirFile4, standardConfigFileName)).isFile()) {
                    return cfile4.toURI().toURL();
                }
                String jbossConfigUrl = System.getProperty("jboss.server.config.url");
                if (jbossConfigUrl != null && (dirFile3 = new File(jbossConfigUrl)).isDirectory() && (cfile3 = new File(dirFile3, standardConfigFileName)).isFile()) {
                    return cfile3.toURI().toURL();
                }
                String tomcatDir = System.getProperty("catalina.home");
                if (tomcatDir != null && (dirFile2 = new File(tomcatDir, "conf")).isDirectory() && (cfile2 = new File(dirFile2, standardConfigFileName)).isFile()) {
                    return cfile2.toURI().toURL();
                }
                String karafDir = System.getProperty("karaf.home");
                if (karafDir != null && (dirFile = new File(karafDir, "etc")).isDirectory() && (cfile = new File(dirFile, standardConfigFileName)).isFile()) {
                    return cfile.toURI().toURL();
                }
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

