/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config;

import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.overlord.commons.config.SystemPropertiesConfiguration;
import org.overlord.commons.config.configurator.Configurator;
import org.overlord.commons.config.vault.VaultLookup;
import org.overlord.commons.services.ServiceRegistryUtil;

public class ConfigurationFactory {
    private static boolean globalLookupsRegistered = false;

    public static Configuration createConfig(String configFileOverride, String standardConfigFileName, Long refreshDelay, String defaultConfigPath, Class<?> defaultConfigLoader) {
        ConfigurationFactory.registerGlobalLookups();
        try {
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)new SystemPropertiesConfiguration());
            Set configurators = ServiceRegistryUtil.getServices(Configurator.class);
            if (!configurators.isEmpty()) {
                for (Configurator configurator : configurators) {
                    configurator.addConfiguration(config, configFileOverride, standardConfigFileName, refreshDelay);
                }
            }
            if (defaultConfigPath != null) {
                config.addConfiguration((Configuration)new PropertiesConfiguration(defaultConfigLoader.getResource(defaultConfigPath)));
            }
            return config;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized void registerGlobalLookups() {
        if (!globalLookupsRegistered) {
            ConfigurationInterpolator.registerGlobalLookup((String)"vault", (StrLookup)new VaultLookup());
            globalLookupsRegistered = true;
        }
    }
}

