/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config.fabric;

import io.fabric8.api.FabricService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrLookup;
import org.overlord.commons.services.ServiceRegistryUtil;

public class ProfileLookup
extends StrLookup {
    private FabricService fabricService;

    private FabricService getFabricService() {
        if (this.fabricService == null) {
            try {
                this.fabricService = (FabricService)ServiceRegistryUtil.getSingleService(FabricService.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.fabricService;
    }

    public String lookup(String key) {
        if (this.getFabricService() != null) {
            String string;
            byte[] fileContent = this.getFabricService().getCurrentContainer().getOverlayProfile().getFileConfiguration(key);
            FileOutputStream os = null;
            try {
                File f = File.createTempFile(key, "");
                os = new FileOutputStream(f);
                f.deleteOnExit();
                IOUtils.write((byte[])fileContent, (OutputStream)os);
                string = f.toURI().toURL().toString();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)os);
            return string;
        }
        return "profile:" + key;
    }
}

