/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config.configurator;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.overlord.commons.config.configurator.AbstractPropertiesFileConfigurator;
import org.overlord.commons.config.configurator.Configurator;
import org.overlord.commons.services.ServiceRegistryUtil;

@Component(name="Fuse Configurator", immediate=true)
@Service(value={Configurator.class})
public class FuseConfigurator
extends AbstractPropertiesFileConfigurator {
    private FabricService fabricService;

    private FabricService getFabricService() {
        if (this.fabricService == null) {
            try {
                this.fabricService = (FabricService)ServiceRegistryUtil.getSingleService(FabricService.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.fabricService;
    }

    @Override
    public boolean accept() {
        String karafDir = System.getProperty("karaf.home");
        return karafDir != null || this.getFabricService() != null;
    }

    @Override
    public Configuration provideConfiguration(String configName, Long refreshDelay) throws ConfigurationException {
        if (this.getFabricService() != null) {
            Map<String, String> properties = this.getProperties(configName);
            return new MapConfiguration(properties);
        }
        return super.provideConfiguration(configName, refreshDelay);
    }

    protected Map<String, String> getProperties(String urlFile) {
        if (this.getFabricService() != null && this.getFabricService().getCurrentContainer() != null && this.getFabricService().getCurrentContainer().getOverlayProfile() != null) {
            Profile profile = this.getFabricService().getCurrentContainer().getOverlayProfile();
            String file_name = "";
            file_name = urlFile.contains(".") ? urlFile.substring(0, urlFile.lastIndexOf(".")) : urlFile;
            Map toReturn = profile.getConfiguration(file_name);
            return toReturn;
        }
        return null;
    }

    @Override
    protected URL findConfigUrl(String configName) {
        String karafDir = System.getProperty("karaf.home");
        if (karafDir != null) {
            File dirFile = new File(karafDir, "etc");
            return this.findConfigUrlInDirectory(dirFile, configName);
        }
        return null;
    }
}

