/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.config;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.overlord.commons.config.ConfigurationFactory;
import org.overlord.commons.services.ServiceRegistryUtil;

public class OverlordConfig {
    public static final String OVERLORD_CONFIG_FILE_NAME = "overlord.config.file.name";
    public static final String OVERLORD_CONFIG_FILE_REFRESH = "overlord.config.file.refresh";
    public static Configuration overlordConfig;
    private static FabricService fabricService;
    protected static final String SAML_KEYSTORE = "overlord.auth.saml-keystore";
    protected static final String SAML_KEYSTORE_PASSWORD = "overlord.auth.saml-keystore-password";
    protected static final String SAML_KEY_ALIAS = "overlord.auth.saml-key-alias";
    protected static final String SAML_KEY_ALIAS_PASSWORD = "overlord.auth.saml-key-alias-password";
    protected static final String HEADERUI_PREFIX = "overlord.headerui.apps";
    private String keystore;
    private Map<String, Map<String, String>> uiHeaderApps;

    public String getSamlKeystoreUrl() {
        if (this.keystore == null) {
            String ks = overlordConfig.getString(SAML_KEYSTORE);
            if (ks == null) {
                throw new RuntimeException("Overlord configuration missing: overlord.auth.saml-keystore");
            }
            if (!ks.startsWith("profile:")) {
                try {
                    File ksFile = new File(ks);
                    if (!ksFile.isFile()) {
                        throw new FileNotFoundException(ks);
                    }
                    ks = ksFile.toURI().toURL().toString();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.keystore = ks;
            } else {
                this.keystore = ks.substring("profile:".length());
                File temp = null;
                try {
                    temp = File.createTempFile(this.keystore, null);
                    temp.deleteOnExit();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(temp);
                    byte[] keystoreContent = null;
                    if (fabricService != null && fabricService.getCurrentContainer() != null && fabricService.getCurrentContainer().getOverlayProfile() != null) {
                        Profile profile = fabricService.getCurrentContainer().getOverlayProfile();
                        keystoreContent = profile.getFileConfiguration(this.keystore);
                    }
                    if (keystoreContent != null) {
                        ((OutputStream)os).write(keystoreContent);
                    }
                    this.keystore = temp.toURI().toURL().toString();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
        return this.keystore;
    }

    public String getSamlKeystorePassword() {
        return overlordConfig.getString(SAML_KEYSTORE_PASSWORD);
    }

    public String getSamlSigningKeyAlias() {
        return overlordConfig.getString(SAML_KEY_ALIAS);
    }

    public String getSamlSigningKeyPassword() {
        return overlordConfig.getString(SAML_KEY_ALIAS_PASSWORD);
    }

    public Map<String, Map<String, String>> getUiHeaders() {
        if (this.uiHeaderApps == null) {
            this.uiHeaderApps = new HashMap<String, Map<String, String>>();
            Iterator keys = overlordConfig.getKeys(HEADERUI_PREFIX);
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String appId = this.getAppIdFromKey(key);
                Map<String, String> app = this.uiHeaderApps.get(appId);
                if (app == null) {
                    app = new HashMap<String, String>();
                    this.uiHeaderApps.put(appId, app);
                }
                String appKey = key.substring(HEADERUI_PREFIX.length() + appId.length() + 2);
                String appVal = overlordConfig.getString(key);
                app.put(appKey, appVal);
            }
        }
        return this.uiHeaderApps;
    }

    private String getAppIdFromKey(String key) {
        int startIdx = HEADERUI_PREFIX.length() + 1;
        int endIdx = key.indexOf(46, startIdx);
        if (endIdx == -1) {
            endIdx = key.length();
        }
        return key.substring(startIdx, endIdx);
    }

    static {
        String configFile = System.getProperty(OVERLORD_CONFIG_FILE_NAME);
        String refreshDelayStr = System.getProperty(OVERLORD_CONFIG_FILE_REFRESH);
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        overlordConfig = ConfigurationFactory.createConfig(configFile, "overlord.properties", refreshDelay, null, null);
        try {
            fabricService = (FabricService)ServiceRegistryUtil.getSingleService(FabricService.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

