/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.util.resource.Resource;

public class MultiDefaultServlet
extends DefaultServlet {
    private static final long serialVersionUID = 164511284620801981L;
    private ContextHandler ctxHandler;
    private final Set<Resource> resourceBases = new LinkedHashSet<Resource>();

    public void init() throws UnavailableException {
        String[] rbs;
        super.init();
        String rbsParam = this.getInitParameter("resourceBases");
        for (String rb : rbs = rbsParam.split("\\|")) {
            try {
                Resource r = this.ctxHandler.newResource(rb);
                this.resourceBases.add(r);
            }
            catch (Exception e) {
                throw new UnavailableException(e.toString());
            }
        }
    }

    public synchronized Resource getResource(String pathInContext) {
        for (Resource resourceBase : this.resourceBases) {
            this.setResourceBase(resourceBase);
            Resource resource = super.getResource(pathInContext);
            if (resource == null || !resource.exists()) continue;
            return resource;
        }
        return null;
    }

    protected ContextHandler initContextHandler(ServletContext servletContext) {
        this.ctxHandler = super.initContextHandler(servletContext);
        return this.ctxHandler;
    }

    private void setResourceBase(Resource resourceBase) {
        try {
            Field declaredField = DefaultServlet.class.getDeclaredField("_resourceBase");
            declaredField.setAccessible(true);
            declaredField.set((Object)this, resourceBase);
            declaredField.setAccessible(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

