/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.eap.extensions.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.overlord.commons.eap.extensions.config.ConfigurationDefinition;
import org.overlord.commons.eap.extensions.config.SubsystemLogger;

public class ConfigurationAdd
extends AbstractAddStepHandler {
    static final ConfigurationAdd INSTANCE = new ConfigurationAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void populateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        model.setEmptyObject();
        for (SimpleAttributeDefinition attr : ConfigurationDefinition.ALL_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = model.get("name").asString();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, true);
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Set properties = resource.getChildren("property");
        for (Resource.ResourceEntry property : properties) {
            ModelNode propertyModel = property.getModel();
            String propertyName = propertyModel.get("name").asString();
            String propertyValue = propertyModel.get("value").asString();
            propertyMap.put(propertyName, propertyValue);
        }
        SubsystemLogger.ROOT_LOGGER.configurationInformation(name, propertyMap);
        this.saveConfiguration(context, name, propertyMap);
    }

    private void saveConfiguration(OperationContext context, String name, Map<String, String> propertyMap) {
        String jndiLoc = "java:/global/overlord-config/" + name;
        ServiceTarget serviceTarget = context.getServiceTarget();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiLoc);
        BinderService binderService = new BinderService(name, propertyMap);
        binderService.getManagedObjectInjector().inject((Object)new ValueManagedReferenceFactory((Value)new ImmediateValue(propertyMap)));
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
        builder.install();
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

