/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.fabric.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.MalformedObjectNameException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pResponse;
import org.overlord.commons.fabric.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilesFabricService {
    private static Logger logger = LoggerFactory.getLogger(ProfilesFabricService.class);
    private J4pClient client;
    private static final String FABRIC_MBEAN_NAME = "io.fabric8:type=Fabric";
    private static final String FABRIC_MAIN_PROFILE_FILE = "io.fabric8.agent.properties";

    public ProfilesFabricService(String jolokiaUrl, String user, String password) {
        try {
            this.client = this.createJolokiaClient(jolokiaUrl, user, password);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.format("fabric.service.jolokia.client.generation.error", jolokiaUrl, user, password), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createProfile(String profileFolder, String profileName, String version, InputStream zipFile) throws IOException, ConfigurationException, MalformedObjectNameException {
        String profileId = this.getProfileName(profileFolder, profileName);
        String versionId = this.getOrCreateVersion(version);
        this.createProfile(versionId, profileId);
        ZipInputStream zis = new ZipInputStream(zipFile);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int count;
            FileOutputStream fos;
            File f;
            byte[] data;
            String name = ze.getName();
            if (name.contains(FABRIC_MAIN_PROFILE_FILE)) {
                data = new byte[2048];
                f = File.createTempFile("temp.fabric", "properties");
                fos = new FileOutputStream(f);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    fos.write(data, 0, count);
                }
                fos.flush();
                fos.close();
                PropertiesConfiguration propertiesFile = new PropertiesConfiguration(f);
                this.parseProperties(profileId, versionId, propertiesFile);
                f.delete();
            } else if (!ze.isDirectory()) {
                data = new byte[2048];
                f = File.createTempFile("temp.fabric", "properties");
                fos = null;
                try {
                    fos = new FileOutputStream(f);
                    while ((count = zis.read(data, 0, 2048)) != -1) {
                        fos.write(data, 0, count);
                    }
                    fos.flush();
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
                FileInputStream is = null;
                try {
                    is = new FileInputStream(f);
                    this.uploadProfilePropertiesFile(versionId, profileId, ze.getName(), is);
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                f.delete();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        this.refreshProfile(versionId, profileId);
        return profileId;
    }

    public void deleteProfile(String version, String profileId) throws MalformedObjectNameException {
        String versionId = this.getVersion(version);
        this.executeJ4P("deleteProfile(java.lang.String,java.lang.String)", true, true, versionId, profileId);
    }

    private void refreshProfile(String versionId, String profileId) throws MalformedObjectNameException {
        this.executeJ4P("refreshProfile", true, false, versionId, profileId);
    }

    private String getProfileName(String profileFolder, String profileId) {
        String profileName = profileFolder.replace("/", "-");
        profileName = profileName.replace("\\", "-");
        profileName = profileName.concat("-").concat(profileId);
        return profileName;
    }

    private String getOrCreateVersion(String version) throws MalformedObjectNameException {
        if (StringUtils.isBlank((String)version)) {
            Map value = (Map)this.executeJ4P("defaultVersion", true, false, new Object[0]);
            if (value != null) {
                return (String)value.get("id");
            }
            throw new RuntimeException(Messages.format("fabric.service.jolokia.get.default.version.empty", new Object[0]));
        }
        boolean existVersion = false;
        Map value = (Map)this.executeJ4P("getVersion(java.lang.String)", false, false, version);
        if (value != null) {
            existVersion = true;
        }
        if (!existVersion) {
            value = (Map)this.executeJ4P("createVersion(java.lang.String)", false, false, version);
            if (value != null) {
                return (String)value.get("id");
            }
            throw new RuntimeException(Messages.format("fabric.service.jolokia.create.version.empty", new Object[0]));
        }
        return version;
    }

    private String getVersion(String version) throws MalformedObjectNameException {
        if (StringUtils.isBlank((String)version)) {
            Map value = (Map)this.executeJ4P("defaultVersion", true, false, new Object[0]);
            if (value != null) {
                return (String)value.get("id");
            }
            throw new RuntimeException(Messages.format("fabric.service.jolokia.get.default.version.empty", new Object[0]));
        }
        return version;
    }

    private void parseProperties(String profileId, String versionId, PropertiesConfiguration props) throws MalformedObjectNameException {
        ArrayList<String> features = new ArrayList<String>();
        ArrayList<String> bundles = new ArrayList<String>();
        ArrayList<String> parents = new ArrayList<String>();
        ArrayList<String> repositories = new ArrayList<String>();
        ArrayList<String> optionals = new ArrayList<String>();
        ArrayList<String> fabs = new ArrayList<String>();
        HashMap<String, String> properties = new HashMap<String, String>();
        Iterator it = props.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.startsWith("feature")) {
                features.add(props.getString(key));
                continue;
            }
            if (key.startsWith("bundle")) {
                bundles.add(props.getString(key));
                continue;
            }
            if (key.startsWith("repository")) {
                repositories.add(props.getString(key));
                continue;
            }
            if (key.startsWith("optional")) {
                optionals.add(props.getString(key));
                continue;
            }
            if (key.startsWith("fab")) {
                fabs.add(props.getString(key));
                continue;
            }
            if (key.equals("attribute.parents")) {
                String parents_str = props.getString(key);
                String[] split = parents_str.split(" ");
                if (split == null || split.length <= 0) continue;
                for (String parent : split) {
                    parents.add(parent);
                }
                continue;
            }
            properties.put(key, props.getString(key));
        }
        if (!features.isEmpty()) {
            this.executeJ4P("setProfileFeatures", true, true, versionId, profileId, this.asJson(features));
        }
        if (!repositories.isEmpty()) {
            this.executeJ4P("setProfileRepositories", true, true, versionId, profileId, this.asJson(repositories));
        }
        if (!bundles.isEmpty()) {
            this.executeJ4P("setProfileBundles", true, true, versionId, profileId, this.asJson(bundles));
        }
        if (!optionals.isEmpty()) {
            this.executeJ4P("setProfileOptionals", true, true, versionId, profileId, this.asJson(optionals));
        }
        if (!fabs.isEmpty()) {
            this.executeJ4P("setProfileFabs", true, true, versionId, profileId, this.asJson(fabs));
        }
        if (!properties.isEmpty()) {
            for (String key : properties.keySet()) {
                this.executeJ4P("setProfileAttribute", true, true, versionId, profileId, key, properties.get(key));
            }
        }
    }

    private Object executeJ4P(String operation, boolean throwException, boolean isVoid, Object ... params) throws MalformedObjectNameException {
        J4pExecRequest request = params != null && params.length > 0 ? new J4pExecRequest(FABRIC_MBEAN_NAME, operation, params) : new J4pExecRequest(FABRIC_MBEAN_NAME, operation, new Object[0]);
        try {
            J4pResponse response = this.client.execute((J4pRequest)request, "POST");
            if (!isVoid) {
                return response.getValue();
            }
        }
        catch (Exception e) {
            if (throwException) {
                throw new RuntimeException(Messages.format("fabric.service.jolokia.error", new Object[0]), e);
            }
            logger.info(Messages.format("fabric.service.jolokia.error", new Object[0]), (Throwable)e);
        }
        return null;
    }

    private String asJson(List<String> list) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("[");
        int i = 0;
        int size = list.size();
        for (String value : list) {
            jsonBuilder.append("\"").append(value).append("\"");
            if (i != size - 1) {
                jsonBuilder.append(",");
            }
            ++i;
        }
        jsonBuilder.append("]");
        return jsonBuilder.toString();
    }

    private void createProfile(String versionId, String profileId) throws MalformedObjectNameException {
        Map value = (Map)this.executeJ4P("getProfile(java.lang.String,java.lang.String)", false, false, versionId, profileId);
        if (value != null) {
            this.executeJ4P("deleteProfile(java.lang.String,java.lang.String)", true, true, versionId, profileId);
        }
        if ((value = (Map)this.executeJ4P("createProfile(java.lang.String,java.lang.String)", true, false, versionId, profileId)) == null) {
            throw new RuntimeException(Messages.format("fabric.service.jolokia.create.profile.error", profileId, versionId));
        }
    }

    protected void uploadProfilePropertiesFile(String versionId, String profileId, String path, InputStream is) throws IOException, MalformedObjectNameException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer);
        this.executeJ4P("setConfigurationFile", true, false, versionId, profileId, path, writer.toString());
    }

    private J4pClient createJolokiaClient(String jolokiaUrl, String user, String password) {
        J4pClientBuilder builder = J4pClient.url((String)jolokiaUrl);
        if (StringUtils.isNotBlank((String)user)) {
            builder = builder.user(user);
        }
        if (StringUtils.isNotBlank((String)password)) {
            builder = builder.password(password);
        }
        return builder.build();
    }
}

