/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.idp;

import java.security.PublicKey;
import java.util.List;
import org.overlord.commons.config.OverlordConfig;
import org.picketlink.common.exceptions.TrustKeyConfigurationException;
import org.picketlink.common.exceptions.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.impl.KeyStoreKeyManager;

public class OverlordIdpKeyStoreKeyManager
extends KeyStoreKeyManager {
    private static final OverlordConfig overlord = new OverlordConfig();

    public void setAuthProperties(List authList) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        this.updateAuthKey(authList, "KeyStoreURL", overlord.getSamlKeystoreUrl());
        this.updateAuthKey(authList, "KeyStorePass", overlord.getSamlKeystorePassword());
        this.updateAuthKey(authList, "SigningKeyAlias", overlord.getSamlSigningKeyAlias());
        this.updateAuthKey(authList, "SigningKeyPass", overlord.getSamlSigningKeyPassword());
        super.setAuthProperties(authList);
    }

    private void updateAuthKey(List authList, String keyToModify, String newValue) {
        for (Object authKey : authList) {
            try {
                String key = (String)authKey.getClass().getMethod("getKey", new Class[0]).invoke(authKey, new Object[0]);
                if (!keyToModify.equals(key)) continue;
                authKey.getClass().getMethod("setValue", String.class).invoke(authKey, newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public PublicKey getValidatingKey(String domain) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        return this.getSigningKeyPair().getPublic();
    }
}

