/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.karaf.commands.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.overlord.commons.karaf.commands.i18n.Messages;

public class GenerateSamlKeystoreUtil {
    private static final int validity = 90;
    private char[] keyPass = null;
    private char[] storePass = null;
    private final String providerName;
    private KeyStore keyStore = null;
    private String storetype = "jks";
    private String srcstoretype = null;
    private String alias = "overlord";
    private String dname = "CN=Picketbox vault, OU=picketbox, O=Jboss, L=Westford, ST=Mass, C=US";
    private String keyAlgName = "RSA";
    private int keysize = 2048;
    private final String startDate;

    public GenerateSamlKeystoreUtil() {
        this.providerName = null;
        this.startDate = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate(String password, File outputFile) throws Exception {
        this.storePass = password.toCharArray();
        this.keyPass = password.toCharArray();
        if (this.storetype == null) {
            this.storetype = KeyStore.getDefaultType();
        }
        if (this.srcstoretype == null) {
            this.srcstoretype = KeyStore.getDefaultType();
        }
        this.keyStore = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
        this.keyStore.load(null, this.storePass);
        this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, null);
        char[] pass = this.storePass;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.keyStore.store(bout, pass);
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        FileOutputStream fout = new FileOutputStream(outputFile);
        try {
            fout.write(bout.toByteArray());
        }
        finally {
            fout.close();
        }
        return true;
    }

    private void doGenKeyPair(String alias, String dname, String keyAlgName, int keysize, String sigAlgName) throws Exception {
        X509Certificate certificate;
        if (keysize == -1) {
            keysize = "EC".equalsIgnoreCase(keyAlgName) ? 256 : ("RSA".equalsIgnoreCase(keyAlgName) ? 2048 : 1024);
        }
        if (this.keyStore.containsAlias(alias)) {
            throw new Exception(Messages.getString("Key.pair.not.generated.alias.alias.already.exists"));
        }
        if (sigAlgName == null) {
            sigAlgName = GenerateSamlKeystoreUtil.getCompatibleSigAlgName(keyAlgName);
        }
        KeyPairGenerator generator = KeyPairGenerator.getInstance(keyAlgName);
        generator.initialize(keysize);
        KeyPair keypair = generator.generateKeyPair();
        PrivateKey privKey = keypair.getPrivate();
        Certificate[] chain = new X509Certificate[1];
        Date date = GenerateSamlKeystoreUtil.getStartDate(this.startDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, 90);
        Date expiryDate = calendar.getTime();
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(new X500Name(dname), new BigInteger("1"), date, expiryDate, new X500Name(dname), SubjectPublicKeyInfo.getInstance((Object)keypair.getPublic().getEncoded()));
        byte[] certBytes = certBuilder.build((ContentSigner)new JCESigner(privKey, "SHA256withRSA")).getEncoded();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        chain[0] = certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certBytes));
        this.keyStore.setKeyEntry(alias, privKey, this.keyPass, chain);
    }

    private static String getCompatibleSigAlgName(String keyAlgName) throws Exception {
        if ("DSA".equalsIgnoreCase(keyAlgName)) {
            return "SHA1WithDSA";
        }
        if ("RSA".equalsIgnoreCase(keyAlgName)) {
            return "SHA256WithRSA";
        }
        if ("EC".equalsIgnoreCase(keyAlgName)) {
            return "SHA256withECDSA";
        }
        throw new Exception(Messages.getString("Cannot.derive.signature.algorithm"));
    }

    private static Date getStartDate(String s) throws IOException {
        GregorianCalendar c = new GregorianCalendar();
        return c.getTime();
    }

    private static class JCESigner
    implements ContentSigner {
        private static final AlgorithmIdentifier PKCS1_SHA256_WITH_RSA_OID = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.11"));
        private Signature signature;
        private ByteArrayOutputStream outputStream;

        public JCESigner(PrivateKey privateKey, String signatureAlgorithm) {
            if (!"SHA256withRSA".equals(signatureAlgorithm)) {
                throw new IllegalArgumentException(Messages.format("Signature algorithm \"{0}\" not yet supported.", signatureAlgorithm));
            }
            try {
                this.outputStream = new ByteArrayOutputStream();
                this.signature = Signature.getInstance(signatureAlgorithm);
                this.signature.initSign(privateKey);
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalArgumentException(gse.getMessage());
            }
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            if (this.signature.getAlgorithm().equals("SHA256withRSA")) {
                return PKCS1_SHA256_WITH_RSA_OID;
            }
            return null;
        }

        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        public byte[] getSignature() {
            try {
                this.signature.update(this.outputStream.toByteArray());
                return this.signature.sign();
            }
            catch (GeneralSecurityException gse) {
                gse.printStackTrace();
                return null;
            }
        }
    }
}

