/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.karaf.commands.configure;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.felix.gogo.commands.Argument;
import org.overlord.commons.codec.AesEncrypter;
import org.overlord.commons.karaf.commands.AbstractFabricCommand;
import org.overlord.commons.karaf.commands.i18n.Messages;
import org.overlord.commons.karaf.commands.saml.GenerateSamlKeystoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigureFabricCommand
extends AbstractFabricCommand {
    private static String OVERLORD_COMMONS_PROFILE_PATH;
    @Argument(index=0, name="password", required=true, multiValued=false)
    protected String password = null;
    boolean allowedPasswordOverwrite = false;
    private static final Logger logger;

    protected Object doExecute() throws Exception {
        String fuse_config_path = this.getOverlordProfilePath();
        String file = fuse_config_path + "overlord-saml.keystore";
        File keystore = new File(file);
        if (this.allowedPasswordOverwrite || !keystore.exists()) {
            logger.info(Messages.getString("generate.saml.keystore.command.correctly.begin"));
            GenerateSamlKeystoreUtil util = new GenerateSamlKeystoreUtil();
            util.generate(this.password, keystore);
            this.updateOverlordProperties();
            logger.info(Messages.getString("generate.saml.keystore.command.correctly.created"));
        } else {
            String message = Messages.getString("overlord.commons.fabric.configured.already");
            logger.info(message);
            System.out.println(message);
        }
        return null;
    }

    public String getOverlordProfilePath() {
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(this.getFabricProfilesPath()).append(OVERLORD_COMMONS_PROFILE_PATH).append(File.separator);
        return fuse_config_path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOverlordProperties() throws Exception {
        String filePath = this.getOverlordPropertiesFilePath();
        Properties props = new Properties();
        FileOutputStream out = null;
        String aesEncryptedValue = AesEncrypter.encrypt((String)this.password);
        StringBuilder aesEncrypterBuilder = new StringBuilder();
        aesEncrypterBuilder.append("$\\{crypt:").append(aesEncryptedValue).append("\\}");
        aesEncryptedValue = aesEncrypterBuilder.toString();
        try {
            out = new FileOutputStream(filePath);
            props.setProperty("overlord.baseUrl", "${container:httpUrl}");
            props.setProperty("overlord.auth.saml-keystore", "${profile:overlord-saml.keystore}");
            props.setProperty("overlord.auth.saml-key-alias", "overlord");
            props.setProperty("overlord.auth.saml-key-alias-password", aesEncryptedValue);
            props.setProperty("overlord.auth.saml-keystore-password", aesEncryptedValue);
            props.store(out, null);
        }
        finally {
            out.close();
        }
    }

    protected String getOverlordPropertiesFilePath() {
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(this.getOverlordProfilePath()).append("overlord.properties");
        return fuse_config_path.toString();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAllowedPasswordOverwrite() {
        return this.allowedPasswordOverwrite;
    }

    public void setAllowedPasswordOverwrite(boolean allowedPasswordOverwrite) {
        this.allowedPasswordOverwrite = allowedPasswordOverwrite;
    }

    static {
        logger = LoggerFactory.getLogger(AbstractConfigureFabricCommand.class);
        OVERLORD_COMMONS_PROFILE_PATH = File.separator.equals("/") ? "overlord/commons.profile" : "overlord\\commons.profile";
    }
}

