/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.karaf.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.overlord.commons.karaf.commands.GenerateSamlKeystoreCommand;
import org.overlord.commons.karaf.commands.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="overlord", name="changePassword")
public class ChangePasswordCommand
extends OsgiCommandSupport {
    protected String karafHome = System.getProperty("karaf.home");
    protected String karafConfigDir = "etc";
    private static final Logger logger = LoggerFactory.getLogger(ChangePasswordCommand.class);
    @Argument(index=0, name="password", required=true, multiValued=false)
    protected String password = null;
    protected String karafConfigPath;
    private boolean creationAllowed;

    public ChangePasswordCommand() {
        StringBuilder sb = new StringBuilder(this.karafHome);
        if (!this.karafHome.endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append(this.karafConfigDir).append(File.separator);
        this.karafConfigPath = sb.toString();
        this.creationAllowed = false;
    }

    protected Object doExecute() throws Exception {
        logger.debug(Messages.getString("overlord.change.password.start"));
        File destFile = new File(this.karafConfigPath + "overlord.properties");
        if (destFile.exists() || this.creationAllowed) {
            Properties usersProperties = new Properties();
            File srcFile = new File(this.karafConfigPath + "users.properties");
            usersProperties.load(new FileInputStream(srcFile));
            String admin = (String)usersProperties.get("admin");
            admin = admin == null ? "" : admin;
            String[] split = admin.split("/s*,/s*");
            String pass = "{CRYPT}" + DigestUtils.sha256Hex((String)this.password) + "{CRYPT}";
            Object[] roles = split.length > 1 ? Arrays.copyOfRange(split, 1, split.length) : new String[]{"overlorduser", "overlordadmin", "admin.sramp"};
            usersProperties.setProperty("admin", pass + "," + StringUtils.join((Object[])roles, (String)","));
            usersProperties.store(new FileOutputStream(srcFile), "");
            logger.info(Messages.getString("overlord.change.password.user.added"));
            logger.debug(Messages.getString("overlord.change.password.generating.keystore"));
            GenerateSamlKeystoreCommand keystoreCommand = new GenerateSamlKeystoreCommand();
            keystoreCommand.setBundleContext(this.bundleContext);
            keystoreCommand.setKeystorePassword(this.password);
            keystoreCommand.execute(this.session);
            logger.debug(Messages.getString("overlord.change.password.end"));
        } else {
            String message = Messages.getString("overlord.change.no.previous.installation");
            logger.info(message);
            System.out.println(message);
        }
        return null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isCreationAllowed() {
        return this.creationAllowed;
    }

    public void setCreationAllowed(boolean creationAllowed) {
        this.creationAllowed = creationAllowed;
    }
}

