/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.karaf.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.felix.gogo.commands.Command;
import org.overlord.commons.karaf.commands.AbstractSamlKeystoreCommand;

@Command(scope="overlord", name="configureFabric")
public class ConfigureFabricProfilesCommand
extends AbstractSamlKeystoreCommand {
    private static final String FABRIC_PROFILES_WINDOWS_DIR = "fabric\\import\\fabric\\configs\\versions\\1.0\\profiles";
    private static final String FABRIC_PROFILES_UNIX_DIR = "fabric/import/fabric/configs/versions/1.0/profiles";
    private static String FABRIC_PROFILES_DIR;
    private static String OVERLORD_COMMONS_PROFILE_PATH;

    @Override
    protected String getConfigPath() {
        String karaf_home = System.getProperty("karaf.home");
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(karaf_home);
        if (!karaf_home.endsWith(File.separator)) {
            fuse_config_path.append(File.separator);
        }
        fuse_config_path.append(FABRIC_PROFILES_DIR).append(File.separator).append(OVERLORD_COMMONS_PROFILE_PATH).append(File.separator);
        return fuse_config_path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateOverlordProperties() throws Exception {
        block11: {
            String filePath = this.getOverlordPropertiesFilePath();
            File overlordFile = new File(filePath);
            if (overlordFile.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(filePath);
                    Properties props = new Properties();
                    props.load(in);
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(filePath);
                        props.setProperty("overlord.auth.saml-key-alias-password", this.password);
                        props.setProperty("overlord.auth.saml-keystore-password", this.password);
                        props.store(out, null);
                        break block11;
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
            }
            boolean created = overlordFile.createNewFile();
            if (created) {
                Properties props = new Properties();
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(filePath);
                    props.setProperty("overlord.baseUrl", "${container:httpUrl}");
                    props.setProperty("overlord.auth.saml-keystore", "profile:overlord-saml.keystore");
                    props.setProperty("overlord.auth.saml-key-alias", "overlord");
                    props.setProperty("overlord.auth.saml-key-alias-password", this.password);
                    props.setProperty("overlord.auth.saml-keystore-password", this.password);
                    props.store(out, null);
                }
                finally {
                    out.close();
                }
            }
        }
    }

    private String getOverlordPropertiesFilePath() {
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(this.getConfigPath()).append("overlord.properties");
        return fuse_config_path.toString();
    }

    static {
        if (File.separator.equals("/")) {
            FABRIC_PROFILES_DIR = FABRIC_PROFILES_UNIX_DIR;
            OVERLORD_COMMONS_PROFILE_PATH = "overlord/commons.profile";
        } else {
            FABRIC_PROFILES_DIR = FABRIC_PROFILES_WINDOWS_DIR;
            OVERLORD_COMMONS_PROFILE_PATH = "overlord\\commons.profile";
        }
    }
}

