/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.overlord.commons.maven.plugin.Feature;
import org.overlord.commons.maven.plugin.featuresxml.FeaturesXml;

@Mojo(name="generate-features-xml", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateFeaturesXmlMojo
extends AbstractMojo {
    @Parameter(property="generate-features-xml.outputFile", defaultValue="${project.build.outputDirectory}/features.xml")
    private String outputFile;
    @Parameter(property="generate-features-xml.attach", defaultValue="false")
    private String attach;
    @Parameter(property="generate-features-xml.features")
    private List<Feature> features;
    @Parameter(property="generate-features-xml.repositories")
    private List<String> repositories;
    @Component
    private MavenProject project;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"-------------------------------------------------");
        this.getLog().info((CharSequence)"Generating Karaf compatible features.xml file to:");
        this.getLog().info((CharSequence)("   " + this.outputFile));
        this.getLog().info((CharSequence)"-------------------------------------------------");
        try {
            FeaturesXml featuresXml = new FeaturesXml();
            this.generate(featuresXml);
            File file = new File(this.outputFile);
            file.getParentFile().mkdirs();
            featuresXml.writeTo(file);
            if ("true".equals(this.attach)) {
                this.attachToBuild(file);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void attachToBuild(File file) {
        this.projectHelper.attachArtifact(this.project, "xml", "features", file);
    }

    private void generate(FeaturesXml featuresXml) throws Exception {
        if (this.repositories != null) {
            for (String repo : this.repositories) {
                featuresXml.addRepository(repo);
            }
        }
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        DependencyNode dependencyGraph = this.dependencyGraphBuilder.buildDependencyGraph(this.project, (ArtifactFilter)filter);
        CollectingDependencyNodeVisitor collectingVizzy = new CollectingDependencyNodeVisitor();
        dependencyGraph.accept((DependencyNodeVisitor)collectingVizzy);
        List nodes = collectingVizzy.getNodes();
        for (Feature feature : this.features) {
            this.getLog().info((CharSequence)("Generating feature '" + feature.getName() + "'"));
            featuresXml.addFeature(feature.getName(), feature.getVersion(), feature.getComment());
            List<Feature> onFeatures = feature.getDependsOnFeatures();
            if (onFeatures != null && !onFeatures.isEmpty()) {
                for (Feature onFeature : onFeatures) {
                    this.getLog().info((CharSequence)("   Depends on feature: " + onFeature.getName() + "/" + onFeature.getVersion()));
                    featuresXml.addFeatureDependency(feature.getName(), feature.getVersion(), onFeature.getName(), onFeature.getVersion());
                }
            }
            PatternIncludesArtifactFilter includesFilter = new PatternIncludesArtifactFilter(feature.getIncludes());
            PatternExcludesArtifactFilter excludesFilter = new PatternExcludesArtifactFilter(feature.getExcludes());
            for (DependencyNode dependencyNode : nodes) {
                boolean includeBundle;
                if (this.isSelf(dependencyNode)) continue;
                Artifact artifact = dependencyNode.getArtifact();
                boolean bl = includeBundle = feature.getIncludes() == null || feature.getIncludes().isEmpty();
                if (includeBundle) {
                    this.getLog().debug((CharSequence)("   Artifact " + artifact + " matches default [all] filter (including)."));
                }
                if (includesFilter.include(artifact)) {
                    this.getLog().debug((CharSequence)("   Artifact " + artifact + " matched include filter (including)."));
                    includeBundle = true;
                }
                if (!excludesFilter.include(artifact)) {
                    this.getLog().debug((CharSequence)("   Artifact " + artifact + " matched exclude filter (excluding)."));
                    includeBundle = false;
                }
                if (!includeBundle) continue;
                featuresXml.addBundle(feature.getName(), feature.getVersion(), this.formatArtifactAsBundle(artifact));
            }
            List<String> bundles = feature.getBundles();
            if (bundles == null || bundles.isEmpty()) continue;
            for (String bundle : bundles) {
                this.getLog().debug((CharSequence)("   Adding explicit bundle: " + bundle));
                featuresXml.addBundle(feature.getName(), feature.getVersion(), bundle);
            }
        }
    }

    private boolean isSelf(DependencyNode dependencyNode) {
        return this.project.getGroupId().equals(dependencyNode.getArtifact().getGroupId()) && this.project.getArtifactId().equals(dependencyNode.getArtifact().getArtifactId());
    }

    private String formatArtifactAsBundle(Artifact artifact) throws Exception {
        StringBuilder builder = new StringBuilder();
        if (this.isBundle(artifact)) {
            builder.append("mvn:");
            builder.append(artifact.getGroupId());
            builder.append("/");
            builder.append(artifact.getArtifactId());
            builder.append("/");
            builder.append(artifact.getBaseVersion());
            if (!"jar".equalsIgnoreCase(artifact.getType())) {
                builder.append("/");
                builder.append(artifact.getType());
            }
        } else {
            builder.append("wrap:mvn:");
            builder.append(artifact.getGroupId());
            builder.append("/");
            builder.append(artifact.getArtifactId());
            builder.append("/");
            builder.append(artifact.getBaseVersion());
            if (!"jar".equalsIgnoreCase(artifact.getType())) {
                builder.append("/");
                builder.append(artifact.getType());
            }
            MavenProject project = this.resolveProject(artifact);
            builder.append("$Bundle-SymbolicName=");
            builder.append(artifact.getGroupId());
            builder.append(".");
            builder.append(artifact.getArtifactId());
            builder.append("&Bundle-Version=");
            builder.append(this.sanitizeVersionForOsgi(artifact.getBaseVersion()));
            if (project.getName() != null && project.getName().trim().length() > 0) {
                builder.append("&Bundle-Name=");
                builder.append(project.getName());
            }
        }
        return builder.toString();
    }

    private Object sanitizeVersionForOsgi(String version) {
        String ver;
        if (version.contains("-")) {
            version = version.substring(0, version.indexOf(45));
        }
        if (!(ver = version.replaceAll("([0-9])[a-zA-Z]+", "$1")).contains(".")) {
            return ver;
        }
        String[] split = ver.split("\\.");
        if (split.length == 3 && this.isNumeric(split[0]) && this.isNumeric(split[1]) && this.isAlpha(split[2])) {
            return split[0] + "." + split[1] + ".0." + split[2];
        }
        return ver;
    }

    private boolean isAlpha(String versionComponent) {
        return versionComponent.length() > 0 && Character.isLetter(versionComponent.charAt(0));
    }

    private boolean isNumeric(String versionComponent) {
        for (int i = 0; i < versionComponent.length(); ++i) {
            if (Character.isDigit(versionComponent.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBundle(Artifact artifact) throws Exception {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        if (result.getArtifacts().isEmpty()) {
            this.getLog().info((CharSequence)("Artifact " + artifact.toString() + " not found in local repository, assuming reactor dependency."));
            return true;
        }
        artifact = (Artifact)result.getArtifacts().iterator().next();
        if (!artifact.getFile().isFile()) {
            throw new Exception("Resolved artifact is not a file: " + artifact.getFile().getAbsolutePath());
        }
        ZipFile jf = null;
        try {
            String value;
            jf = new JarFile(artifact.getFile());
            Manifest manifest = ((JarFile)jf).getManifest();
            if (manifest == null) {
                this.getLog().info((CharSequence)("Artifact " + artifact.toString() + " missing a manifest!  Assuming not a bundle."));
                boolean bl = false;
                return bl;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes != null && (value = attributes.getValue("Bundle-SymbolicName")) != null && value.trim().length() > 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            jf.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenProject resolveProject(Artifact artifact) throws Exception {
        Artifact pomArtifact = this.repositorySystem.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(pomArtifact);
        ArtifactResolutionResult resolved = this.repositorySystem.resolve(request);
        pomArtifact = (Artifact)resolved.getArtifacts().iterator().next();
        InputStream contentStream = null;
        MavenProject project = null;
        try {
            contentStream = new FileInputStream(pomArtifact.getFile());
            Model model = new MavenXpp3Reader().read(contentStream);
            project = new MavenProject(model);
        }
        finally {
            contentStream.close();
        }
        return project;
    }
}

