/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.overlord.commons.maven.plugin.Merge;

@Mojo(name="merge-files", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class MergeFilesMojo
extends AbstractMojo {
    @Parameter(property="merges", required=true)
    private Merge[] merges;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Merge mergeData : this.merges) {
            Properties properties = new Properties();
            FileInputStream is = null;
            FileOutputStream os = null;
            for (File propertiesFile : mergeData.getFiles()) {
                if (!propertiesFile.exists()) {
                    throw new MojoExecutionException("File does not exist: " + propertiesFile.getAbsolutePath());
                }
                try {
                    is = new FileInputStream(propertiesFile);
                    properties.load(is);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Exception while loading the file " + propertiesFile.getAbsolutePath(), e);
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            File destination = mergeData.getDestination();
            try {
                os = new FileOutputStream(destination);
                properties.store(os, destination.getName());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception writing in the file " + destination.getName(), e);
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }
}

