/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.osgi.weld;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.overlord.commons.osgi.vfs.IVfsBundleFactory;
import org.overlord.commons.osgi.vfs.VfsBundle;

public class BundleURLScanner
extends URLScanner {
    public BundleURLScanner(ClassLoader classLoader, ServletContext context) {
        super(classLoader);
    }

    protected void handleURL(URL url, Set<String> classes, Set<URL> urls) {
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IVfsBundleFactory.class.getName());
        if (serviceReference == null) {
            throw new RuntimeException("Failed to find OSGi service [IVfsBundleFactory].");
        }
        IVfsBundleFactory factory = (IVfsBundleFactory)bundleContext.getService(serviceReference);
        VfsBundle vfsBundle = factory.getVfsBundle(url);
        File file = vfsBundle.asFile(url);
        HashSet<String> paths = new HashSet<String>();
        if (file.isDirectory()) {
            File webClasses = new File(file, "WEB-INF/classes");
            if (webClasses.exists()) {
                paths.add(webClasses.getAbsolutePath());
            } else {
                paths.add(file.getAbsolutePath());
            }
        }
        this.handle(paths, classes, urls);
    }
}

