/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.Set;
import org.overlord.commons.services.OSGiServiceRegistry;
import org.overlord.commons.services.ServiceLoaderServiceRegistry;
import org.overlord.commons.services.ServiceRegistry;

public class ServiceRegistryUtil {
    private static ServiceRegistry registry = null;

    private static ServiceRegistry getRegistry() {
        if (registry == null) {
            registry = ServiceRegistryUtil.createRegistry();
        }
        return registry;
    }

    private static ServiceRegistry createRegistry() {
        if ("true".equals(System.getProperty("overlord-commons-config.osgi-enabled"))) {
            return new OSGiServiceRegistry();
        }
        return new ServiceLoaderServiceRegistry();
    }

    public static <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        return ServiceRegistryUtil.getRegistry().getSingleService(serviceInterface);
    }

    public static <T> Set<T> getServices(Class<T> serviceInterface) {
        return ServiceRegistryUtil.getRegistry().getServices(serviceInterface);
    }
}

