/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.overlord.commons.services.Messages;
import org.overlord.commons.services.ServiceRegistry;

public class ServiceLoaderServiceRegistry
implements ServiceRegistry {
    private Map<Class<?>, Set<?>> servicesCache = new HashMap();
    private Map<Class<?>, Object> serviceCache = new HashMap();

    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        T rval;
        block4: {
            if (this.serviceCache.containsKey(serviceInterface)) {
                return (T)this.serviceCache.get(serviceInterface);
            }
            rval = null;
            try {
                Iterator<T> i$ = ServiceLoader.load(serviceInterface).iterator();
                if (!i$.hasNext()) break block4;
                T service = i$.next();
                if (rval == null) {
                    rval = service;
                    break block4;
                }
                throw new IllegalStateException(Messages.getString("ServiceLoaderServiceRegistry.MultipleImplsFound") + serviceInterface);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                // empty catch block
            }
        }
        this.serviceCache.put(serviceInterface, rval);
        return rval;
    }

    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        if (this.servicesCache.containsKey(serviceInterface)) {
            return this.servicesCache.get(serviceInterface);
        }
        LinkedHashSet<T> services = new LinkedHashSet<T>();
        try {
            for (T service : ServiceLoader.load(serviceInterface)) {
                services.add(service);
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
        this.servicesCache.put(serviceInterface, services);
        return services;
    }
}

