/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.services;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.overlord.commons.services.ServiceListener;
import org.overlord.commons.services.ServiceRegistry;

public class CompositeServiceRegistry
implements ServiceRegistry {
    private List<ServiceRegistry> registries = new ArrayList<ServiceRegistry>();

    @Override
    public <T> T getSingleService(Class<T> serviceInterface) throws IllegalStateException {
        for (ServiceRegistry registry : this.registries) {
            T service = registry.getSingleService(serviceInterface);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    @Override
    public <T> Set<T> getServices(Class<T> serviceInterface) {
        LinkedHashSet<T> rval = new LinkedHashSet<T>();
        for (ServiceRegistry registry : this.registries) {
            Set<T> svcs = registry.getServices(serviceInterface);
            if (svcs == null) continue;
            rval.addAll(svcs);
        }
        return rval;
    }

    @Override
    public <T> void addServiceListener(Class<T> serviceInterface, ServiceListener<T> listener) {
        for (ServiceRegistry registry : this.registries) {
            registry.addServiceListener(serviceInterface, listener);
        }
    }

    @Override
    public <T> void removeServiceListener(ServiceListener<T> listener) {
        for (ServiceRegistry registry : this.registries) {
            registry.removeServiceListener(listener);
        }
    }

    public void addRegistry(ServiceRegistry registry) {
        this.registries.add(registry);
    }
}

