/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.servlet.http;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.solder.core.Requires;
import org.jboss.solder.servlet.event.ImplicitServletObjectsHolder;
import org.jboss.solder.servlet.http.ContextPath;
import org.jboss.solder.servlet.http.HttpServletRequestContext;

@Requires(value={"javax.servlet.Servlet"})
public class ImplicitHttpServletObjectsProducer
implements Serializable {
    private static final long serialVersionUID = 6680938621833824390L;
    @Inject
    private ImplicitServletObjectsHolder holder;

    @Produces
    @RequestScoped
    protected HttpSession getHttpSession() {
        if (this.holder.getHttpSession() == null) {
            throw new IllegalStateException("Attempted to inject an HttpSession before it has been initialized.");
        }
        return this.holder.getHttpSession();
    }

    @Produces
    @Typed(value={HttpServletRequestContext.class})
    @RequestScoped
    protected HttpServletRequestContext getHttpServletRequestContext() {
        return this.holder.getHttpServletRequestContext();
    }

    @Produces
    @Typed(value={HttpServletRequest.class})
    @RequestScoped
    protected HttpServletRequest getHttpServletRequest() {
        if (this.holder.getHttpServletRequest() == null) {
            throw new IllegalStateException("Attempted to inject an HttpServletRequest before it has been initialized.");
        }
        return this.holder.getHttpServletRequest();
    }

    @Produces
    @Typed(value={HttpServletResponse.class})
    @RequestScoped
    protected HttpServletResponse getHttpServletResponse() {
        if (this.holder.getHttpServletResponse() == null) {
            throw new IllegalStateException("Attempted to inject an HttpServletResponse before it has been initialized.");
        }
        return this.holder.getHttpServletResponse();
    }

    @Produces
    @RequestScoped
    protected List<Cookie> getCookies() {
        return Arrays.asList(this.getHttpServletRequest().getCookies());
    }

    @Produces
    @ContextPath
    protected String getContextPath() {
        return this.getHttpServletRequest().getContextPath();
    }
}

