/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.config.xml.parser.namespace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.solder.config.xml.model.XmlItem;
import org.jboss.solder.config.xml.parser.SaxNode;
import org.jboss.solder.config.xml.parser.namespace.NamespaceElementResolver;
import org.jboss.solder.config.xml.parser.namespace.PackageNamespaceElementResolver;

public class CompositeNamespaceElementResolver
implements NamespaceElementResolver {
    private final Set<String> notFound = new HashSet<String>();
    private final List<PackageNamespaceElementResolver> resolvers = new ArrayList<PackageNamespaceElementResolver>();

    public CompositeNamespaceElementResolver(Collection<String> packages) {
        for (String s : packages) {
            this.resolvers.add(new PackageNamespaceElementResolver(s));
        }
    }

    public CompositeNamespaceElementResolver(String[] packages) {
        for (String s : packages) {
            this.resolvers.add(new PackageNamespaceElementResolver(s));
        }
    }

    @Override
    public XmlItem getItemForNamespace(SaxNode node, XmlItem parent) {
        if (this.notFound.contains(node.getName())) {
            return null;
        }
        for (PackageNamespaceElementResolver p : this.resolvers) {
            XmlItem xi = p.getItemForNamespace(node, parent);
            if (xi == null) continue;
            return xi;
        }
        this.notFound.add(node.getName());
        return null;
    }
}

