/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.exception.control;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.solder.bean.Beans;
import org.jboss.solder.bean.ImmutableInjectionPoint;
import org.jboss.solder.exception.control.CaughtException;
import org.jboss.solder.exception.control.HandlerMethod;
import org.jboss.solder.exception.control.Handles;
import org.jboss.solder.exception.control.OutboundParameterValueRedefiner;
import org.jboss.solder.exception.control.TraversalMode;
import org.jboss.solder.literal.AnyLiteral;
import org.jboss.solder.reflection.annotated.InjectableMethod;

public class HandlerMethodImpl<T extends Throwable>
implements HandlerMethod<T> {
    private final Class<?> beanClass;
    private Bean<?> bean;
    private final Set<Annotation> qualifiers;
    private final Type exceptionType;
    private final AnnotatedMethod<?> handler;
    private final TraversalMode traversalMode;
    private final int precedence;
    private final Method javaMethod;
    private final AnnotatedParameter<?> handlerParameter;
    private final Set<InjectionPoint> injectionPoints;

    public static boolean isHandler(AnnotatedMethod<?> method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        for (AnnotatedParameter param : method.getParameters()) {
            if (!param.isAnnotationPresent(Handles.class)) continue;
            return true;
        }
        return false;
    }

    public static AnnotatedParameter<?> findHandlerParameter(AnnotatedMethod<?> method) {
        if (!HandlerMethodImpl.isHandler(method)) {
            throw new IllegalArgumentException("Method is not a valid handler");
        }
        AnnotatedParameter returnParam = null;
        for (AnnotatedParameter param : method.getParameters()) {
            if (!param.isAnnotationPresent(Handles.class)) continue;
            returnParam = param;
            break;
        }
        return returnParam;
    }

    public HandlerMethodImpl(AnnotatedMethod<?> method, BeanManager bm) {
        if (!HandlerMethodImpl.isHandler(method)) {
            throw new IllegalArgumentException(MessageFormat.format("{0} is not a valid handler", method));
        }
        HashSet<Annotation> tmpQualifiers = new HashSet<Annotation>();
        this.handler = method;
        this.javaMethod = method.getJavaMember();
        this.handlerParameter = HandlerMethodImpl.findHandlerParameter(method);
        if (!this.handlerParameter.isAnnotationPresent(Handles.class)) {
            throw new IllegalArgumentException("Method is not annotated with @Handles");
        }
        this.traversalMode = ((Handles)this.handlerParameter.getAnnotation(Handles.class)).during();
        this.precedence = ((Handles)this.handlerParameter.getAnnotation(Handles.class)).precedence();
        tmpQualifiers.addAll(Beans.getQualifiers(bm, (Iterable<Annotation>)this.handlerParameter.getAnnotations()));
        if (tmpQualifiers.isEmpty()) {
            tmpQualifiers.add((Annotation)AnyLiteral.INSTANCE);
        }
        this.qualifiers = tmpQualifiers;
        this.beanClass = method.getJavaMember().getDeclaringClass();
        this.exceptionType = ((ParameterizedType)this.handlerParameter.getBaseType()).getActualTypeArguments()[0];
        this.injectionPoints = new HashSet<InjectionPoint>(method.getParameters().size() - 1);
        for (AnnotatedParameter param : method.getParameters()) {
            if (param.equals(this.handlerParameter)) continue;
            this.injectionPoints.add(new ImmutableInjectionPoint(param, bm, this.getBean(bm), false, false));
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public synchronized Bean<?> getBean(BeanManager bm) {
        if (this.bean == null) {
            this.bean = bm.resolve(bm.getBeans(this.beanClass, new Annotation[0]));
        }
        return this.bean;
    }

    public Set<Annotation> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public Type getExceptionType() {
        return this.exceptionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(CaughtException<T> event, BeanManager bm) {
        CreationalContext ctx = null;
        try {
            ctx = bm.createCreationalContext(null);
            Object handlerInstance = bm.getReference(this.getBean(bm), this.beanClass, ctx);
            InjectableMethod<?> im = this.createInjectableMethod(this.handler, this.getBean(bm), bm);
            im.invoke(handlerInstance, ctx, new OutboundParameterValueRedefiner(event, bm, this));
        }
        finally {
            if (ctx != null) {
                ctx.release();
            }
        }
    }

    private <X> InjectableMethod<X> createInjectableMethod(AnnotatedMethod<X> handlerMethod, Bean<?> bean, BeanManager manager) {
        return new InjectableMethod<X>(handlerMethod, bean, manager);
    }

    public TraversalMode getTraversalMode() {
        return this.traversalMode;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public AnnotatedParameter<?> getHandlerParameter() {
        return this.handlerParameter;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return new HashSet<InjectionPoint>(this.injectionPoints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlerMethod that = (HandlerMethod)o;
        if (!this.qualifiers.equals(that.getQualifiers())) {
            return false;
        }
        if (!this.exceptionType.equals(that.getExceptionType())) {
            return false;
        }
        if (this.precedence != that.getPrecedence()) {
            return false;
        }
        return this.traversalMode == that.getTraversalMode();
    }

    public int hashCode() {
        int result = this.beanClass.hashCode();
        result = 5 * result + this.qualifiers.hashCode();
        result = 5 * result + this.exceptionType.hashCode();
        result = 5 * result + this.traversalMode.hashCode();
        result = 5 * result + this.precedence;
        result = 5 * result + this.javaMethod.hashCode();
        result = 5 * result + this.handlerParameter.hashCode();
        return result;
    }

    public String toString() {
        return "Qualifiers: " + this.qualifiers + " " + "TraversalMode: " + this.traversalMode + " " + "Handles Type: " + this.exceptionType + " " + "Precedence: " + this.precedence + " " + this.handler.toString();
    }
}

