/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.ui.header;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.commons.ui.header.MockHttpServletRequest;
import org.overlord.commons.ui.header.MockHttpServletResponse;
import org.overlord.commons.ui.header.MockServletConfig;
import org.overlord.commons.ui.header.OverlordHeaderDataJS;

public class OverlordHeaderJSTest {
    private static final String EXPECTED_HEADERS = "Cache-control: no-cache, no-store, must-revalidate\r\nContent-Type: text/javascript\r\nDate: <DATE VALUE>\r\nExpires: <DATE VALUE>\r\nPragma: no-cache\r\n";
    private static final String EXPECTED_CONTENT = "var OVERLORD_HEADER_DATA = {\r\n  \"username\" : \"ewittman\",\r\n  \"logoutLink\" : \"?GLO=true\",\r\n  \"primaryBrand\" : \"Unit Test\",\r\n  \"secondaryBrand\" : \"App One\",\r\n  \"tabs\" : [ {\r\n    \"app-id\" : \"app-1\",\r\n    \"href\" : \"/app-1/index.html\",\r\n    \"label\" : \"Application One\",\r\n    \"active\" : true\r\n  }, {\r\n    \"app-id\" : \"app-2\",\r\n    \"href\" : \"/app-2/index.html\",\r\n    \"label\" : \"Application Two\",\r\n    \"active\" : false\r\n  }, {\r\n    \"app-id\" : \"app-3\",\r\n    \"href\" : \"/app-3/index.html\",\r\n    \"label\" : \"Application Three\",\r\n    \"active\" : false\r\n  } ]\r\n};";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoGetHttpServletRequestHttpServletResponse() throws URISyntaxException, ServletException, IOException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockServletConfig config = new MockServletConfig("app-1");
        File tempConfigDir = this.createAndPrepConfigDir();
        System.setProperty("org.overlord.apps.config-dir", tempConfigDir.getCanonicalPath());
        try {
            OverlordHeaderDataJS servlet = new OverlordHeaderDataJS();
            servlet.init((ServletConfig)config);
            servlet.doGet((HttpServletRequest)request, (HttpServletResponse)response);
            String headers = response.getOutputHeadersAsString();
            String content = response.getOutputAsString();
            Assert.assertEquals((Object)this.normalize(EXPECTED_HEADERS), (Object)this.normalize(headers));
            Assert.assertEquals((Object)this.normalize(EXPECTED_CONTENT), (Object)this.normalize(content));
        }
        finally {
            System.setProperty("org.overlord.apps.config-dir", "");
        }
    }

    private File createAndPrepConfigDir() throws IOException {
        File dir = File.createTempFile("_ovlunit", "configDir");
        if (dir.isFile()) {
            dir.delete();
        }
        dir.mkdirs();
        File configFile1 = new File(dir, "app1-overlordapp.properties");
        Properties props = new Properties();
        props.setProperty("overlordapp.app-id", "app-1");
        props.setProperty("overlordapp.href", "/app-1/index.html");
        props.setProperty("overlordapp.label", "Application One");
        props.setProperty("overlordapp.primary-brand", "Unit Test");
        props.setProperty("overlordapp.secondary-brand", "App One");
        props.store(new FileWriter(configFile1), "Overlord App 1");
        File configFile2 = new File(dir, "app2-overlordapp.properties");
        props = new Properties();
        props.setProperty("overlordapp.app-id", "app-2");
        props.setProperty("overlordapp.href", "/app-2/index.html");
        props.setProperty("overlordapp.label", "Application Two");
        props.setProperty("overlordapp.primary-brand", "Unit Test");
        props.setProperty("overlordapp.secondary-brand", "App Two");
        props.store(new FileWriter(configFile2), "Overlord App 2");
        File configFile3 = new File(dir, "app3-overlordapp.properties");
        props = new Properties();
        props.setProperty("overlordapp.app-id", "app-3");
        props.setProperty("overlordapp.href", "/app-3/index.html");
        props.setProperty("overlordapp.label", "Application Three");
        props.setProperty("overlordapp.primary-brand", "Unit Test");
        props.setProperty("overlordapp.secondary-brand", "App Three");
        props.store(new FileWriter(configFile3), "Overlord App 3");
        return dir;
    }

    private String normalize(String multiLineValue) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(multiLineValue));
        String line = null;
        while ((line = reader.readLine()) != null) {
            builder.append(line.trim()).append("\r\n");
        }
        return builder.toString();
    }
}

