/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.jboss.downloads.overlord.sramp._2013.auditing.AuditEntry;
import org.jboss.resteasy.plugins.providers.atom.Category;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Link;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Artifact;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampConstants;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SrampAtomUtils {
    private SrampAtomUtils() {
    }

    public static BaseArtifactType unwrapSrampArtifact(ArtifactType artifactType, Artifact artifact) {
        return artifactType.unwrap(artifact);
    }

    public static BaseArtifactType unwrapSrampArtifact(Entry entry) {
        ArtifactType artifactType = SrampAtomUtils.getArtifactType(entry);
        return SrampAtomUtils.unwrapSrampArtifact(artifactType, entry);
    }

    public static BaseArtifactType unwrapSrampArtifact(ArtifactType artifactType, Entry entry) {
        try {
            Artifact artifact = SrampAtomUtils.getArtifactWrapper(entry);
            if (artifact != null) {
                if (artifactType.isExtendedType()) {
                    artifactType = SrampAtomUtils.disambiguateExtendedType(entry, artifactType);
                }
                return SrampAtomUtils.unwrapSrampArtifact(artifactType, artifact);
            }
            return null;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static Artifact getArtifactWrapper(Entry entry) throws JAXBException {
        return SrampAtomUtils.unwrap(entry, Artifact.class);
    }

    public static Entry wrapSrampArtifact(BaseArtifactType artifact) throws URISyntaxException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Entry entry = new Entry();
        if (artifact.getUuid() != null) {
            entry.setId(new URI(artifact.getUuid()));
        }
        if (artifact.getLastModifiedTimestamp() != null) {
            entry.setUpdated(artifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
        }
        if (artifact.getName() != null) {
            entry.setTitle(artifact.getName());
        }
        if (artifact.getCreatedTimestamp() != null) {
            entry.setPublished(artifact.getCreatedTimestamp().toGregorianCalendar().getTime());
        }
        if (artifact.getCreatedBy() != null) {
            entry.getAuthors().add(new Person(artifact.getCreatedBy()));
        }
        if (artifact.getDescription() != null) {
            entry.setSummary(artifact.getDescription());
        }
        Artifact srampArty = new Artifact();
        Method method = Artifact.class.getMethod("set" + artifact.getClass().getSimpleName(), artifact.getClass());
        method.invoke((Object)srampArty, artifact);
        entry.setAnyOtherJAXBObject((Object)srampArty);
        return entry;
    }

    public static ArtifactType getArtifactType(Entry entry) {
        ArtifactType type = SrampAtomUtils.getArtifactTypeFromEntry(entry);
        if (type.isExtendedType()) {
            boolean derived = "true".equals(entry.getExtensionAttributes().get(SrampConstants.SRAMP_DERIVED_QNAME));
            String extendedType = (String)entry.getExtensionAttributes().get(SrampConstants.SRAMP_EXTENDED_TYPE_QNAME);
            type.setExtendedDerivedType(derived);
            type.setExtendedType(extendedType);
        }
        return type;
    }

    protected static ArtifactType getArtifactTypeFromEntry(Entry entry) {
        try {
            Artifact artifactWrapper = SrampAtomUtils.getArtifactWrapper(entry);
            if (artifactWrapper != null) {
                String hint = null;
                Element wrapperNode = SrampAtomUtils.getArtifactWrapperNode(entry);
                if (wrapperNode != null) {
                    hint = SrampAtomUtils.getArtifactWrappedElementName(wrapperNode);
                }
                return ArtifactType.valueOf((Artifact)artifactWrapper, (String)hint);
            }
        }
        catch (JAXBException e) {
            // empty catch block
        }
        List categories = entry.getCategories();
        for (Category cat : categories) {
            if (!"x-s-ramp:2010:type".equals(cat.getScheme().toString())) continue;
            String atype = cat.getTerm();
            ArtifactType artifactType = ArtifactType.valueOf((String)atype);
            if (artifactType.isExtendedType()) {
                artifactType = SrampAtomUtils.disambiguateExtendedType(entry, artifactType);
            }
            return artifactType;
        }
        Link link = entry.getLinkByRel("self");
        if (link != null) {
            URI href = link.getHref();
            String path = href.getPath();
            String[] split = path.split("/");
            String atype = split[split.length - 2];
            ArtifactType artifactType = ArtifactType.valueOf((String)atype);
            if (artifactType.isExtendedType()) {
                artifactType = SrampAtomUtils.disambiguateExtendedType(entry, artifactType);
            }
            return artifactType;
        }
        return ArtifactType.valueOf((String)"Document");
    }

    protected static ArtifactType disambiguateExtendedType(Entry entry, ArtifactType artifactType) {
        String et = artifactType.getExtendedType();
        boolean convertToDocument = false;
        if (entry.getContent() != null) {
            convertToDocument = true;
        } else {
            Element node = SrampAtomUtils.getArtifactWrapperNode(entry);
            if (node != null) {
                String type = SrampAtomUtils.getArtifactWrappedElementName(node);
                if (ExtendedDocument.class.getSimpleName().equals(type)) {
                    convertToDocument = true;
                }
            }
        }
        if (convertToDocument) {
            artifactType = ArtifactType.valueOf((BaseArtifactEnum)BaseArtifactEnum.EXTENDED_DOCUMENT);
            artifactType.setExtendedType(et);
        }
        return artifactType;
    }

    public static <T> T unwrap(Entry entry, Class<T> clazz) throws JAXBException {
        if (entry.getAnyOtherElement() == null && entry.getAnyOther().isEmpty()) {
            return null;
        }
        Object object = entry.getAnyOtherJAXBObject(clazz, new Class[0]);
        if (object == null) {
            for (Object anyOther : entry.getAnyOther()) {
                if (anyOther == null || !anyOther.getClass().equals(clazz)) continue;
                object = anyOther;
                break;
            }
        }
        return (T)object;
    }

    protected static Element getArtifactWrapperNode(Entry entry) {
        Element element = entry.getAnyOtherElement();
        if (SrampAtomUtils.isWrapperElement(element)) {
            return element;
        }
        for (Object anyOther : entry.getAnyOther()) {
            if (!(anyOther instanceof Element) || !SrampAtomUtils.isWrapperElement((Element)anyOther)) continue;
            return (Element)anyOther;
        }
        return null;
    }

    protected static String getArtifactWrappedElementName(Element artifactWrapperElement) {
        NodeList nodes = artifactWrapperElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            if (item.getNodeType() != 1) continue;
            return item.getLocalName();
        }
        return null;
    }

    private static boolean isWrapperElement(Element element) {
        if (element == null) {
            return false;
        }
        QName qname = new QName(element.getNamespaceURI(), element.getLocalName());
        return qname.equals(SrampConstants.S_RAMP_WRAPPER_ELEM);
    }

    public static RDF unwrapRDF(Entry entry) {
        try {
            return SrampAtomUtils.unwrap(entry, RDF.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static AuditEntry unwrapAuditEntry(Entry entry) {
        try {
            return SrampAtomUtils.unwrap(entry, AuditEntry.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

