/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive;

import java.io.File;
import javax.xml.bind.JAXBException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchiveJaxbUtils;

public class SrampArchiveEntry {
    private String path;
    private BaseArtifactType metaData;
    private File contentFile;
    private File metaDataFile;

    public SrampArchiveEntry() {
    }

    public SrampArchiveEntry(String path, File metaDataFile, File contentFile) {
        this.setPath(path);
        this.setMetaData(null);
        this.metaDataFile = metaDataFile;
        this.contentFile = contentFile;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public BaseArtifactType getMetaData() {
        if (this.metaData == null && this.metaDataFile != null && this.metaDataFile.exists()) {
            try {
                this.metaData = SrampArchiveJaxbUtils.readMetaData(this.metaDataFile);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.metaData;
    }

    public void setMetaData(BaseArtifactType metaData) {
        this.metaData = metaData;
    }

    public boolean hasContent() {
        return this.contentFile != null && this.contentFile.isFile();
    }
}

