/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive.expand;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.ArchiveUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.expand.ArtifactFilter;
import org.overlord.sramp.atom.archive.expand.CandidateArtifact;
import org.overlord.sramp.atom.archive.expand.DefaultArtifactFilter;
import org.overlord.sramp.atom.archive.expand.DefaultMetaDataFactory;
import org.overlord.sramp.atom.archive.expand.DiscoveredArtifact;
import org.overlord.sramp.atom.archive.expand.DiscoveredArtifacts;
import org.overlord.sramp.atom.archive.expand.MetaDataFactory;
import org.overlord.sramp.atom.archive.expand.MetaDataProvider;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveContext;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveException;

public abstract class ZipToSrampArchive {
    private static final ArtifactFilter DEFAULT_ARTIFACT_FILTER = new DefaultArtifactFilter();
    private static final MetaDataFactory DEFAULT_META_DATA_FACTORY = new DefaultMetaDataFactory();
    private File originalJar;
    private boolean shouldDeleteOriginalJar;
    private File jarWorkDir;
    private ArtifactFilter artifactFilter = DEFAULT_ARTIFACT_FILTER;
    private MetaDataFactory metaDataFactory = DEFAULT_META_DATA_FACTORY;
    private List<MetaDataProvider> metaDataProviders = new ArrayList<MetaDataProvider>();
    private ZipToSrampArchiveContext context;

    public ZipToSrampArchive(File jar) throws ZipToSrampArchiveException {
        this.originalJar = jar;
        this.shouldDeleteOriginalJar = false;
        this.jarWorkDir = null;
        try {
            this.jarWorkDir = ZipToSrampArchive.createJarWorkDir();
            ArchiveUtils.unpackToWorkDir(this.originalJar, this.jarWorkDir);
            this.context = new ZipToSrampArchiveContext(this.jarWorkDir);
        }
        catch (IOException e) {
            if (this.jarWorkDir != null) {
                try {
                    FileUtils.deleteDirectory((File)this.jarWorkDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ZipToSrampArchiveException(e);
        }
    }

    public ZipToSrampArchive(InputStream jarStream) throws ZipToSrampArchiveException {
        this.originalJar = null;
        this.shouldDeleteOriginalJar = true;
        this.jarWorkDir = null;
        try {
            this.originalJar = File.createTempFile("j2sramp", ".jar");
            ZipToSrampArchive.copyJarStream(jarStream, this.originalJar);
            this.jarWorkDir = ZipToSrampArchive.createJarWorkDir();
            ArchiveUtils.unpackToWorkDir(this.originalJar, this.jarWorkDir);
            this.context = new ZipToSrampArchiveContext(this.jarWorkDir);
        }
        catch (IOException e) {
            if (this.jarWorkDir != null) {
                try {
                    FileUtils.deleteDirectory((File)this.jarWorkDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.originalJar != null && this.originalJar.exists()) {
                this.originalJar.delete();
            }
            throw new ZipToSrampArchiveException(e);
        }
    }

    public void setContextParam(String name, Object value) {
        this.context.put(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyJarStream(InputStream jarStream, File jarOutputFile) throws IOException {
        FileOutputStream oStream = null;
        try {
            oStream = FileUtils.openOutputStream((File)jarOutputFile);
            IOUtils.copy((InputStream)jarStream, (OutputStream)oStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)jarStream);
            IOUtils.closeQuietly((OutputStream)oStream);
        }
    }

    private static File createJarWorkDir() throws IOException {
        File tempFile = File.createTempFile("j2sramp", ".work");
        tempFile.delete();
        tempFile.mkdir();
        return tempFile;
    }

    public SrampArchive createSrampArchive() throws ZipToSrampArchiveException {
        this.artifactFilter.setContext(this.context);
        this.metaDataFactory.setContext(this.context);
        DiscoveredArtifacts discoveredArtifacts = this.discoverArtifacts();
        discoveredArtifacts.index(this.jarWorkDir);
        this.generateMetaData(discoveredArtifacts);
        try {
            SrampArchive archive = new SrampArchive();
            for (DiscoveredArtifact artifact : discoveredArtifacts) {
                String path = artifact.getArchivePath();
                archive.addEntry(path, artifact.getMetaData(), artifact.getContent());
            }
            return archive;
        }
        catch (Exception e) {
            throw new ZipToSrampArchiveException(e);
        }
    }

    private void generateMetaData(DiscoveredArtifacts discoveredArtifacts) {
        for (DiscoveredArtifact artifact : discoveredArtifacts) {
            BaseArtifactType metaData = this.metaDataFactory.createMetaData(artifact);
            for (MetaDataProvider metaDataProvider : this.metaDataProviders) {
                metaDataProvider.provideMetaData(metaData);
            }
            artifact.setMetaData(metaData);
        }
    }

    private DiscoveredArtifacts discoverArtifacts() {
        DiscoveredArtifacts artifacts = new DiscoveredArtifacts();
        Collection files = FileUtils.listFiles((File)this.jarWorkDir, null, (boolean)true);
        for (File file : files) {
            CandidateArtifact candidate = new CandidateArtifact(file, this.jarWorkDir);
            if (!this.artifactFilter.accepts(candidate)) continue;
            artifacts.add(file);
        }
        return artifacts;
    }

    public void close() throws IOException {
        FileUtils.deleteDirectory((File)this.jarWorkDir);
        if (this.shouldDeleteOriginalJar) {
            this.originalJar.delete();
        }
    }

    public void setArtifactFilter(ArtifactFilter artifactFilter) {
        this.artifactFilter = artifactFilter;
    }

    public ArtifactFilter getArtifactFilter() {
        return this.artifactFilter;
    }

    public void setMetaDataFactory(MetaDataFactory metaDataFactory) {
        this.metaDataFactory = metaDataFactory;
    }

    public void addMetaDataProvider(MetaDataProvider metaDataProvider) {
        this.metaDataProviders.add(metaDataProvider);
    }

    public MetaDataFactory getMetaDataFactory() {
        return this.metaDataFactory;
    }

    public static void closeQuietly(ZipToSrampArchive j2sramp) {
        try {
            if (j2sramp != null) {
                j2sramp.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

