/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.err.SrampAtomException;

@Provider
@ServerInterceptor
@Produces(value={"application/sramp-atom-exception"})
@Consumes(value={"application/sramp-atom-exception"})
public class SrampAtomExceptionProvider
implements ExceptionMapper<SrampAtomException>,
MessageBodyWriter<SrampAtomException>,
MessageBodyReader<SrampAtomException> {
    public Response toResponse(SrampAtomException exception) {
        Response.ResponseBuilder builder = Response.status((int)500);
        builder.header("Error-Message", (Object)SrampAtomExceptionProvider.getRootCause(exception).getMessage());
        builder.type("application/sramp-atom-exception");
        String stack = SrampAtomExceptionProvider.getRootStackTrace(exception);
        builder.entity((Object)stack);
        return builder.build();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        return SrampAtomException.class.equals(type);
    }

    public long getSize(SrampAtomException t, Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        return -1L;
    }

    public void writeTo(SrampAtomException error, Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (httpHeaders != null) {
            httpHeaders.putSingle((Object)"Error-Message", (Object)SrampAtomExceptionProvider.getRootCause(error).getMessage());
        }
        String stack = SrampAtomExceptionProvider.getRootStackTrace(error);
        entityStream.write(stack.getBytes("UTF-8"));
        entityStream.flush();
    }

    public static String getRootStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        SrampAtomExceptionProvider.getRootCause(t).printStackTrace(writer);
        return sw.getBuffer().toString();
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable root;
        for (root = t; root.getCause() != null && root.getCause() != root; root = root.getCause()) {
        }
        return root;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        return SrampAtomException.class.equals(type) || MediaType.APPLICATION_SRAMP_ATOM_EXCEPTION_TYPE.equals(mediaType);
    }

    public SrampAtomException readFrom(Class<SrampAtomException> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String msg;
        List lines = IOUtils.readLines((InputStream)entityStream);
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line).append("\n");
        }
        String stackTrace = buffer.toString();
        String string = msg = httpHeaders == null ? null : (String)httpHeaders.getFirst((Object)"Error-Message");
        if (msg == null) {
            msg = "An unexpected error was thrown by the S-RAMP repository.";
        }
        SrampAtomException error = new SrampAtomException(msg, stackTrace);
        return error;
    }
}

