/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.visitors;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.jboss.resteasy.plugins.providers.atom.Category;
import org.jboss.resteasy.plugins.providers.atom.Content;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Link;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Artifact;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.visitors.ArtifactContentTypeVisitor;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorAdapter;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;

public class ArtifactToSummaryAtomEntryVisitor
extends ArtifactVisitorAdapter {
    protected String baseUrl = "";
    protected Entry atomEntry;
    protected Exception failure;
    protected Set<String> propertyNames;

    public ArtifactToSummaryAtomEntryVisitor(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ArtifactToSummaryAtomEntryVisitor(String baseUrl, Set<String> propNames) {
        this.baseUrl = baseUrl;
        this.propertyNames = propNames;
    }

    public void reset() {
        this.atomEntry = null;
        this.failure = null;
    }

    public Entry getAtomEntry() throws Exception {
        if (this.failure != null) {
            throw this.failure;
        }
        return this.atomEntry;
    }

    protected void setAtomEntry(Entry entry) {
        this.atomEntry = entry;
    }

    protected void visitBase(BaseArtifactType artifact) {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)artifact);
            Entry entry = new Entry();
            if (artifact.getUuid() != null) {
                entry.setId(new URI(artifact.getUuid()));
            }
            if (artifact.getLastModifiedTimestamp() != null) {
                entry.setUpdated(artifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
            }
            if (artifact.getName() != null) {
                entry.setTitle(artifact.getName());
            }
            if (artifact.getCreatedTimestamp() != null) {
                entry.setPublished(artifact.getCreatedTimestamp().toGregorianCalendar().getTime());
            }
            if (artifact.getCreatedBy() != null) {
                entry.getAuthors().add(new Person(artifact.getCreatedBy()));
            }
            if (artifact.getDescription() != null) {
                entry.setSummary(artifact.getDescription());
            }
            entry.getExtensionAttributes().put(SrampConstants.SRAMP_DERIVED_QNAME, String.valueOf(artifactType.isDerived()));
            String atomLink = this.baseUrl + "/s-ramp/" + artifactType.getModel() + "/" + artifactType.getType() + "/" + artifact.getUuid();
            String mediaLink = atomLink + "/media";
            if (SrampModelUtils.isDocumentArtifact((BaseArtifactType)artifact)) {
                ArtifactContentTypeVisitor ctVisitor = new ArtifactContentTypeVisitor();
                ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVisitor, (BaseArtifactType)artifact);
                Content content = new Content();
                content.setType(ctVisitor.getContentType());
                content.setSrc(new URI(mediaLink));
                entry.setContent(content);
                Link linkToAlternate = new Link();
                linkToAlternate.setType(ctVisitor.getContentType());
                linkToAlternate.setRel("alternate");
                linkToAlternate.setHref(new URI(mediaLink));
                entry.getLinks().add(linkToAlternate);
            }
            Link linkToSelf = new Link();
            linkToSelf.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
            linkToSelf.setRel("self");
            linkToSelf.setHref(new URI(atomLink));
            entry.getLinks().add(linkToSelf);
            Link linkToEditMedia = new Link();
            linkToEditMedia.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
            linkToEditMedia.setRel("edit-media");
            linkToEditMedia.setHref(new URI(mediaLink));
            entry.getLinks().add(linkToEditMedia);
            Link linkToEdit = new Link();
            linkToEdit.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
            linkToEdit.setRel("edit");
            linkToEdit.setHref(new URI(atomLink));
            entry.getLinks().add(linkToEdit);
            Category typeCat = new Category();
            typeCat.setTerm(artifactType.getType());
            typeCat.setLabel(artifactType.getLabel());
            typeCat.setScheme(new URI("x-s-ramp:2010:type"));
            entry.getCategories().add(typeCat);
            Category modelCat = new Category();
            modelCat.setTerm(artifactType.getModel());
            modelCat.setLabel(artifactType.getLabel());
            modelCat.setScheme(new URI("x-s-ramp:2010:model"));
            entry.getCategories().add(modelCat);
            this.setAtomEntry(entry);
            if (this.includeArtifact()) {
                Artifact artifactWrapper = new Artifact();
                BaseArtifactType includedArtifact = this.createIncludedArtifact(artifact);
                Method method = Artifact.class.getMethod("set" + includedArtifact.getClass().getSimpleName(), includedArtifact.getClass());
                method.invoke((Object)artifactWrapper, includedArtifact);
                entry.setAnyOtherJAXBObject((Object)artifactWrapper);
            }
        }
        catch (Exception e) {
            this.failure = e;
        }
    }

    public void visit(ExtendedArtifactType artifact) {
        super.visit(artifact);
        if (this.atomEntry != null) {
            String extendedType = artifact.getExtendedType();
            this.atomEntry.getExtensionAttributes().put(SrampConstants.SRAMP_EXTENDED_TYPE_QNAME, extendedType);
        }
    }

    public void visit(ExtendedDocument artifact) {
        super.visit(artifact);
        if (this.atomEntry != null) {
            String extendedType = artifact.getExtendedType();
            this.atomEntry.getExtensionAttributes().put(SrampConstants.SRAMP_EXTENDED_TYPE_QNAME, extendedType);
        }
    }

    protected boolean includeArtifact() {
        return this.propertyNames != null && this.propertyNames.size() > 0;
    }

    protected BaseArtifactType createIncludedArtifact(BaseArtifactType artifact) throws InstantiationException, IllegalAccessException {
        if (this.includeArtifact()) {
            BaseArtifactType includedArtifact = (BaseArtifactType)artifact.getClass().newInstance();
            List properties = artifact.getProperty();
            for (Property prop : properties) {
                if (!this.propertyNames.contains(prop.getPropertyName())) continue;
                SrampModelUtils.setCustomProperty((BaseArtifactType)includedArtifact, (String)prop.getPropertyName(), (String)prop.getPropertyValue());
            }
            return includedArtifact;
        }
        return null;
    }
}

