/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.ArchiveUtils;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.archive.SrampArchiveException;
import org.overlord.sramp.atom.archive.SrampArchiveJaxbUtils;
import org.overlord.sramp.atom.i18n.Messages;

public class SrampArchive {
    private File originalFile = null;
    private boolean shouldDeleteOriginalFile;
    private File workDir = null;

    public SrampArchive() throws SrampArchiveException {
        try {
            this.workDir = SrampArchive.createWorkDir();
        }
        catch (IOException e) {
            if (this.workDir != null && this.workDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)this.workDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new SrampArchiveException(Messages.i18n.format("FAILED_TO_CREATE_WORK_DIR", new Object[0]), e);
        }
    }

    public SrampArchive(File file) throws SrampArchiveException {
        this();
        this.originalFile = file;
        this.shouldDeleteOriginalFile = false;
        try {
            ArchiveUtils.unpackToWorkDir(this.originalFile, this.workDir);
        }
        catch (IOException e) {
            if (this.workDir != null) {
                try {
                    FileUtils.deleteDirectory((File)this.workDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new SrampArchiveException(Messages.i18n.format("FAILED_TO_UNPACK_ARCHIVE_TO_WORK_DIR", new Object[0]), e);
        }
    }

    public SrampArchive(InputStream input) throws SrampArchiveException {
        this();
        this.originalFile = null;
        this.shouldDeleteOriginalFile = true;
        try {
            this.originalFile = File.createTempFile("s-ramp-archive", ".zip");
            SrampArchive.copyZipStream(input, this.originalFile);
            ArchiveUtils.unpackToWorkDir(this.originalFile, this.workDir);
        }
        catch (IOException e) {
            if (this.workDir != null) {
                try {
                    FileUtils.deleteDirectory((File)this.workDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.originalFile != null && this.originalFile.exists()) {
                this.originalFile.delete();
            }
            throw new SrampArchiveException(Messages.i18n.format("FAILED_TO_UNPACK_ARCHIVE_TO_WORK_DIR", new Object[0]), e);
        }
    }

    private static File createWorkDir() throws IOException {
        File tempFile = File.createTempFile("s-ramp-archive", ".work");
        tempFile.delete();
        tempFile.mkdir();
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyZipStream(InputStream zipStream, File zipOutputFile) throws IOException {
        FileOutputStream oStream = null;
        try {
            oStream = FileUtils.openOutputStream((File)zipOutputFile);
            IOUtils.copy((InputStream)zipStream, (OutputStream)oStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipStream);
            IOUtils.closeQuietly((OutputStream)oStream);
        }
    }

    public void close() throws IOException {
        FileUtils.deleteDirectory((File)this.workDir);
        if (this.shouldDeleteOriginalFile) {
            this.originalFile.delete();
        }
    }

    public static void closeQuietly(SrampArchive archive) {
        try {
            if (archive != null) {
                archive.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Collection<SrampArchiveEntry> getEntries() throws SrampArchiveException {
        Collection files = FileUtils.listFiles((File)this.workDir, (String[])new String[]{"atom"}, (boolean)true);
        ArrayList<SrampArchiveEntry> entries = new ArrayList<SrampArchiveEntry>(files.size());
        for (File metaDataFile : files) {
            String metaDataAbsPath = metaDataFile.getAbsolutePath();
            File contentFile = new File(metaDataAbsPath.substring(0, metaDataAbsPath.length() - 5));
            String path = contentFile.getAbsolutePath();
            path = path.substring(this.workDir.getAbsolutePath().length() + 1);
            path = path.replace('\\', '/');
            entries.add(new SrampArchiveEntry(path, metaDataFile, contentFile));
        }
        return entries;
    }

    public InputStream getInputStream(SrampArchiveEntry entry) throws IOException {
        File artifactPath = new File(this.workDir, entry.getPath());
        if (artifactPath.exists()) {
            return FileUtils.openInputStream((File)artifactPath);
        }
        return null;
    }

    public void addEntry(String path, BaseArtifactType metaData, InputStream content) throws SrampArchiveException {
        if (path == null) {
            throw new SrampArchiveException(Messages.i18n.format("INVALID_ENTRY_PATH", new Object[0]));
        }
        if (metaData == null) {
            throw new SrampArchiveException(Messages.i18n.format("MISSING_META_DATA", new Object[0]));
        }
        File metaDataFile = new File(this.workDir, path + ".atom");
        File contentFile = new File(this.workDir, path);
        if (metaDataFile.exists()) {
            throw new SrampArchiveException(Messages.i18n.format("ARCHIVE_ALREADY_EXISTS", new Object[0]));
        }
        metaDataFile.getParentFile().mkdirs();
        if (content != null) {
            this.writeContent(contentFile, content);
        }
        try {
            SrampArchiveJaxbUtils.writeMetaData(metaDataFile, metaData);
        }
        catch (JAXBException e) {
            throw new SrampArchiveException(e);
        }
    }

    public void updateEntry(SrampArchiveEntry entry, InputStream content) throws SrampArchiveException {
        if (entry.getPath() == null) {
            throw new SrampArchiveException(Messages.i18n.format("INVALID_ENTRY_PATH", new Object[0]));
        }
        File contentFile = new File(this.workDir, entry.getPath());
        File metaDataFile = new File(this.workDir, entry.getPath() + ".atom");
        if (content != null) {
            this.writeContent(contentFile, content);
        }
        if (entry.getMetaData() != null) {
            try {
                SrampArchiveJaxbUtils.writeMetaData(metaDataFile, entry.getMetaData());
            }
            catch (JAXBException e) {
                throw new SrampArchiveException(e);
            }
        }
    }

    private void writeContent(File workPath, InputStream content) throws SrampArchiveException {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(workPath);
            IOUtils.copy((InputStream)content, (OutputStream)outStream);
        }
        catch (Throwable t) {
            throw new SrampArchiveException(Messages.i18n.format("ERROR_WRITING_CONTENT", new Object[0]), t);
        }
        finally {
            IOUtils.closeQuietly((InputStream)content);
            IOUtils.closeQuietly((OutputStream)outStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File pack() throws SrampArchiveException {
        try {
            File archiveFile = null;
            try {
                archiveFile = File.createTempFile("s-ramp-archive", ".sramp");
                FileOutputStream outputStream = FileUtils.openOutputStream((File)archiveFile);
                ZipOutputStream zipOutputStream = null;
                try {
                    zipOutputStream = new ZipOutputStream(outputStream);
                    Collection<SrampArchiveEntry> entries = this.getEntries();
                    for (SrampArchiveEntry entry : entries) {
                        this.packEntry(entry, zipOutputStream);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zipOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)zipOutputStream);
            }
            catch (Throwable t) {
                if (archiveFile != null && archiveFile.isFile()) {
                    archiveFile.delete();
                }
                throw t;
            }
            return archiveFile;
        }
        catch (Throwable t) {
            throw new SrampArchiveException(Messages.i18n.format("ERROR_PACKING_ARCHIVE", new Object[0]), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packEntry(SrampArchiveEntry entry, ZipOutputStream zipOutputStream) throws IOException, IllegalArgumentException, SecurityException, URISyntaxException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JAXBException {
        InputStream contentStream = this.getInputStream(entry);
        if (contentStream != null) {
            zipOutputStream.putNextEntry(new ZipEntry(entry.getPath()));
            try {
                IOUtils.copy((InputStream)contentStream, (OutputStream)zipOutputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)contentStream);
            }
            zipOutputStream.closeEntry();
        }
        zipOutputStream.putNextEntry(new ZipEntry(entry.getPath() + ".atom"));
        SrampArchiveJaxbUtils.writeMetaData(zipOutputStream, entry.getMetaData());
        zipOutputStream.closeEntry();
    }

    public SrampArchiveEntry getEntry(String archivePath) {
        File contentFile = new File(this.workDir, archivePath);
        File metaDataFile = new File(this.workDir, archivePath + ".atom");
        SrampArchiveEntry rval = null;
        if (metaDataFile.exists()) {
            rval = new SrampArchiveEntry(archivePath, metaDataFile, contentFile);
        }
        return rval;
    }

    public boolean containsEntry(String archivePath) {
        File metaDataFile = new File(this.workDir, archivePath + ".atom");
        return metaDataFile.exists();
    }

    public boolean removeEntry(String archivePath) {
        File metaDataFile = new File(this.workDir, archivePath + ".atom");
        File contentFile = new File(this.workDir, archivePath);
        if (metaDataFile.isFile()) {
            metaDataFile.delete();
            if (contentFile.isFile()) {
                contentFile.delete();
            }
            return true;
        }
        return false;
    }
}

