/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.archive.expand.registry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveException;
import org.overlord.sramp.atom.archive.expand.registry.ArchiveInfo;
import org.overlord.sramp.atom.archive.expand.registry.TypeHintInfo;
import org.overlord.sramp.atom.archive.expand.registry.ZipToSrampArchiveProvider;
import org.overlord.sramp.common.ArtifactType;

public final class ZipToSrampArchiveRegistry {
    private static Map<ArtifactType, ZipToSrampArchiveProvider> providerCache = new HashMap<ArtifactType, ZipToSrampArchiveProvider>();
    private static Map<String, String> sortedPathEntryHintMapCache = null;
    private static List<ZipToSrampArchiveProvider> providers = new ArrayList<ZipToSrampArchiveProvider>();

    private static void discoverProviders() {
        for (ZipToSrampArchiveProvider provider : ServiceLoader.load(ZipToSrampArchiveProvider.class)) {
            providers.add(provider);
        }
    }

    public static ZipToSrampArchive createExpander(ArtifactType artifactType, InputStream zipStream) throws ZipToSrampArchiveException {
        ZipToSrampArchiveProvider provider = ZipToSrampArchiveRegistry.getProvider(artifactType);
        if (provider == null) {
            return null;
        }
        return provider.createExtractor(artifactType, zipStream);
    }

    public static ZipToSrampArchive createExpander(ArtifactType artifactType, File zipFile) throws ZipToSrampArchiveException {
        ZipToSrampArchiveProvider provider = ZipToSrampArchiveRegistry.getProvider(artifactType);
        if (provider == null) {
            return null;
        }
        return provider.createExtractor(artifactType, zipFile);
    }

    public static boolean canExpand(ArtifactType artifactType) throws ZipToSrampArchiveException {
        ZipToSrampArchiveProvider provider = ZipToSrampArchiveRegistry.getProvider(artifactType);
        return provider != null;
    }

    protected static ZipToSrampArchiveProvider getProvider(ArtifactType artifactType) {
        ZipToSrampArchiveProvider provider = null;
        if (providerCache.containsKey(artifactType)) {
            provider = providerCache.get(artifactType);
        } else {
            provider = null;
            for (ZipToSrampArchiveProvider p : providers) {
                if (!p.accept(artifactType)) continue;
                provider = p;
                break;
            }
            providerCache.put(artifactType, provider);
        }
        return provider;
    }

    public static ArchiveInfo inspectArchive(InputStream resourceInputStream) throws ZipToSrampArchiveException {
        try {
            ZipEntry entry;
            String matchedType = null;
            if (sortedPathEntryHintMapCache == null) {
                sortedPathEntryHintMapCache = new LinkedHashMap<String, String>();
                ArrayList<TypeHintInfo> typeHintInfoList = new ArrayList<TypeHintInfo>();
                for (ZipToSrampArchiveProvider p : providers) {
                    typeHintInfoList.add(p.getArchiveTypeHints());
                }
                Collections.sort(typeHintInfoList);
                for (TypeHintInfo typeHintInfo : typeHintInfoList) {
                    for (String path : typeHintInfo.pathEntryHintMap.keySet()) {
                        sortedPathEntryHintMapCache.put(path, typeHintInfo.pathEntryHintMap.get(path));
                    }
                }
            }
            ZipInputStream zip = new ZipInputStream(resourceInputStream);
            String toc = "";
            while ((entry = zip.getNextEntry()) != null) {
                toc = toc + entry.getName() + "\n";
            }
            String lowerCaseToc = toc.toLowerCase();
            for (String path : sortedPathEntryHintMapCache.keySet()) {
                if (!lowerCaseToc.contains(path.toLowerCase())) continue;
                matchedType = sortedPathEntryHintMapCache.get(path);
                break;
            }
            ArchiveInfo archiveInfo = new ArchiveInfo(matchedType, toc);
            return archiveInfo;
        }
        catch (IOException e) {
            throw new ZipToSrampArchiveException(e.getMessage(), e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceInputStream);
        }
    }

    static {
        ZipToSrampArchiveRegistry.discoverProviders();
    }
}

