/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.atom.mappers;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.overlord.sramp.atom.i18n.Messages;
import org.overlord.sramp.common.ontology.SrampOntology;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;
import org.w3._2002._07.owl_.Class;
import org.w3._2002._07.owl_.Ontology;

public class RdfToOntologyMapper {
    private static final RdfToOntologyMapper instance = new RdfToOntologyMapper();

    public static SrampOntology rdf2ontology(RDF rdf) throws Exception {
        SrampOntology ontology = new SrampOntology();
        instance.map(rdf, ontology);
        return ontology;
    }

    public void map(RDF rdf, SrampOntology ontology) throws Exception {
        SrampOntology.SrampOntologyClass oclass;
        String uuid = (String)rdf.getOtherAttributes().get(new QName("http://docs.oasis-open.org/s-ramp/ns/s-ramp-v1.0", "uuid"));
        if (uuid != null && uuid.trim().length() > 0) {
            ontology.setUuid(uuid);
        }
        Ontology rdfOntology = rdf.getOntology();
        String base = (String)rdf.getOtherAttributes().get(new QName("http://www.w3.org/XML/1998/namespace", "base"));
        ontology.setBase(base);
        ontology.setId(rdfOntology.getID());
        ontology.setLabel(rdfOntology.getLabel());
        ontology.setComment(rdfOntology.getComment());
        ArrayList<Object[]> classes = new ArrayList<Object[]>();
        HashMap<String, SrampOntology.SrampOntologyClass> idIndex = new HashMap<String, SrampOntology.SrampOntologyClass>();
        HashMap<String, SrampOntology.SrampOntologyClass> uriIndex = new HashMap<String, SrampOntology.SrampOntologyClass>();
        for (Class rdfClass : rdf.getClazz()) {
            oclass = new SrampOntology.SrampOntologyClass();
            oclass.setId(rdfClass.getID());
            oclass.setLabel(rdfClass.getLabel());
            oclass.setComment(rdfClass.getComment());
            String uri = base + "#" + rdfClass.getID();
            oclass.setUri(new URI(uri));
            Object[] classData = new Object[]{oclass, rdfClass.getSubClassOf() != null ? rdfClass.getSubClassOf().getResource() : null};
            classes.add(classData);
            idIndex.put(rdfClass.getID(), oclass);
            uriIndex.put(uri, oclass);
        }
        for (Object[] classData : classes) {
            oclass = (SrampOntology.SrampOntologyClass)classData[0];
            String resourceRef = (String)classData[1];
            if (resourceRef == null) {
                ontology.getRootClasses().add(oclass);
                continue;
            }
            SrampOntology.SrampOntologyClass parent = (SrampOntology.SrampOntologyClass)idIndex.get(resourceRef);
            if (parent == null) {
                parent = (SrampOntology.SrampOntologyClass)uriIndex.get(resourceRef);
            }
            if (parent == null) {
                throw new Exception(Messages.i18n.format("FAILED_TO_RESOLVE_PARENT", new Object[]{resourceRef}));
            }
            parent.getChildren().add(oclass);
            oclass.setParent(parent);
        }
    }
}

