/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.java.artifactbuilder;

import java.io.IOException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.artifactbuilder.AbstractArtifactBuilder;
import org.overlord.sramp.common.artifactbuilder.ArtifactBuilder;
import org.overlord.sramp.common.artifactbuilder.RelationshipContext;

@Component(name="Java Artifact Builder", immediate=true)
@Service(value={ArtifactBuilder.class})
public class JavaClassArtifactBuilder
extends AbstractArtifactBuilder {
    public ArtifactBuilder buildArtifacts(BaseArtifactType primaryArtifact, ArtifactContent artifactContent) throws IOException {
        super.buildArtifacts(primaryArtifact, artifactContent);
        ClassParser parser = new ClassParser(this.getContentStream(), primaryArtifact.getName());
        JavaClass javaClass = parser.parse();
        if (javaClass.isInterface()) {
            ((ExtendedDocument)primaryArtifact).setExtendedType("JavaInterface");
        } else if (javaClass.isClass()) {
            ((ExtendedDocument)primaryArtifact).setExtendedType("JavaClass");
        } else if (javaClass.isEnum()) {
            ((ExtendedDocument)primaryArtifact).setExtendedType("JavaEnum");
        }
        String packageName = javaClass.getPackageName();
        String className = javaClass.getClassName();
        primaryArtifact.setName(className);
        String shortName = className;
        if (className.lastIndexOf(46) > 0) {
            shortName = className.substring(className.lastIndexOf(46) + 1);
        }
        SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"packageName", (String)packageName);
        SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"className", (String)shortName);
        return this;
    }

    public ArtifactBuilder buildRelationships(RelationshipContext context) throws IOException {
        return this;
    }
}

