/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.java.artifactbuilder;

import java.io.IOException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.artifactbuilder.AbstractArtifactBuilder;
import org.overlord.sramp.common.artifactbuilder.ArtifactBuilder;
import org.overlord.sramp.common.artifactbuilder.RelationshipContext;

@Component(name="Maven POM Artifact Builder", immediate=true)
@Service(value={ArtifactBuilder.class})
public class MavenPomArtifactBuilder
extends AbstractArtifactBuilder {
    public ArtifactBuilder buildArtifacts(BaseArtifactType primaryArtifact, ArtifactContent artifactContent) throws IOException {
        super.buildArtifacts(primaryArtifact, artifactContent);
        try {
            Model model = new MavenXpp3Reader().read(this.getContentStream());
            MavenProject project = new MavenProject(model);
            ((ExtendedDocument)primaryArtifact).setExtendedType("MavenPom");
            for (String key : project.getProperties().stringPropertyNames()) {
                String value = project.getProperties().getProperty(key);
                SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)("maven.property." + key), (String)value);
            }
            if (primaryArtifact.getDescription() == null) {
                primaryArtifact.setDescription(project.getDescription());
            }
            if (primaryArtifact.getName() == null) {
                primaryArtifact.setName(project.getName());
            }
            if (primaryArtifact.getVersion() == null) {
                primaryArtifact.setVersion(project.getVersion());
            }
            SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"maven.artifactId", (String)model.getArtifactId());
            SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"maven.groupId", (String)model.getGroupId());
            SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"maven.version", (String)model.getVersion());
            SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"maven.packaging", (String)model.getPackaging());
            if (model.getParent() != null) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"maven.parent.artifactId", (String)model.getParent().getArtifactId());
                SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"maven.parent.groupId", (String)model.getParent().getGroupId());
                SrampModelUtils.setCustomProperty((BaseArtifactType)primaryArtifact, (String)"maven.parent.version", (String)model.getParent().getVersion());
            }
            return this;
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public ArtifactBuilder buildRelationships(RelationshipContext context) throws IOException {
        return this;
    }
}

