/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.java.artifacttypedetector;

import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.integration.ArchiveContext;
import org.overlord.sramp.integration.artifacttypedetector.AbstractArtifactTypeDetector;

public class JavaArtifactTypeDetector
extends AbstractArtifactTypeDetector {
    public ArtifactType detect(ArtifactContent content) {
        if ("pom.xml".equals(content.getFilename())) {
            return ArtifactType.valueOf((String)"MavenPom", (boolean)true);
        }
        if ("beans.xml".equals(content.getFilename())) {
            return ArtifactType.valueOf((String)"BeanArchiveDescriptor", (boolean)true);
        }
        return null;
    }

    public ArtifactType detect(ArtifactContent content, ArchiveContext archiveContext) {
        if (archiveContext.isExpandedFromArchive()) {
            if (content.getFilename().endsWith(".class")) {
                return ArtifactType.valueOf((String)"JavaClass", (boolean)true);
            }
            return this.detect(content);
        }
        if (archiveContext.hasArchiveEntry("META-INF/application.xml") || content.getFilename().endsWith(".ear")) {
            return ArtifactType.valueOf((String)"JavaEnterpriseApplication", (boolean)true);
        }
        if (archiveContext.hasArchiveEntry("WEB-INF/web.xml") || content.getFilename().endsWith(".war")) {
            return ArtifactType.valueOf((String)"JavaWebApplication", (boolean)true);
        }
        if (archiveContext.hasArchiveEntry("META-INF/MANIFEST.MF") || content.getFilename().endsWith(".jar")) {
            return ArtifactType.valueOf((String)"JavaArchive", (boolean)true);
        }
        return null;
    }

    public int getPriority() {
        return 1;
    }
}

